/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.eks.ICluster;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps;
import software.amazon.awscdk.services.stepfunctions.tasks.;
import software.amazon.awscdk.services.stepfunctions.tasks.EksCallProps;
import software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.EksCallProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EksCallProps
extends JsiiSerializable,
TaskStateBaseProps {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public HttpMethods getHttpMethod();

    @NotNull
    public String getHttpPath();

    @Nullable
    default public Map<String, List<String>> getQueryParameters() {
        return null;
    }

    @Nullable
    default public TaskInput getRequestBody() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EksCallProps> {
        private ICluster cluster;
        private HttpMethods httpMethod;
        private String httpPath;
        private Map<String, List<String>> queryParameters;
        private TaskInput requestBody;
        private String comment;
        private Duration heartbeat;
        private String inputPath;
        private IntegrationPattern integrationPattern;
        private String outputPath;
        private String resultPath;
        private Duration timeout;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder httpMethod(HttpMethods httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder httpPath(String httpPath) {
            this.httpPath = httpPath;
            return this;
        }

        public Builder queryParameters(Map<String, ? extends List<String>> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder requestBody(TaskInput requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public EksCallProps build() {
            return new Jsii.Proxy(this.cluster, this.httpMethod, this.httpPath, this.queryParameters, this.requestBody, this.comment, this.heartbeat, this.inputPath, this.integrationPattern, this.outputPath, this.resultPath, this.timeout);
        }
    }
}

