/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig;
import software.amazon.jsii.JsiiSerializable;

public interface ResourceConfig
extends JsiiSerializable {
    public Number getInstanceCount();

    public InstanceType getInstanceType();

    public Number getVolumeSizeInGb();

    public IKey getVolumeEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number instanceCount;
        private InstanceType instanceType;
        private Number volumeSizeInGb;
        private IKey volumeEncryptionKey;

        public Builder instanceCount(Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder volumeSizeInGb(Number volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        public Builder volumeEncryptionKey(IKey volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public ResourceConfig build() {
            return new Jsii.Proxy(this.instanceCount, this.instanceType, this.volumeSizeInGb, this.volumeEncryptionKey, null);
        }
    }
}

