/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.SnsPublishProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.SnsPublishProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SnsPublishProps
extends JsiiSerializable,
TaskStateBaseProps {
    @NotNull
    public TaskInput getMessage();

    @NotNull
    public ITopic getTopic();

    @Nullable
    default public Boolean getMessagePerSubscriptionType() {
        return null;
    }

    @Nullable
    default public String getSubject() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TaskInput message;
        private ITopic topic;
        private Boolean messagePerSubscriptionType;
        private String subject;
        private String comment;
        private Duration heartbeat;
        private String inputPath;
        private IntegrationPattern integrationPattern;
        private String outputPath;
        private String resultPath;
        private Duration timeout;

        public Builder message(TaskInput message) {
            this.message = message;
            return this;
        }

        public Builder topic(ITopic topic) {
            this.topic = topic;
            return this;
        }

        public Builder messagePerSubscriptionType(Boolean messagePerSubscriptionType) {
            this.messagePerSubscriptionType = messagePerSubscriptionType;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SnsPublishProps build() {
            return new Jsii.Proxy(this.message, this.topic, this.messagePerSubscriptionType, this.subject, this.comment, this.heartbeat, this.inputPath, this.integrationPattern, this.outputPath, this.resultPath, this.timeout, null);
        }
    }
}

