/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Objects;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig;
import software.amazon.awscdk.services.stepfunctions.Task;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.SendToQueueProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.SendToQueue")
public class SendToQueue
extends JsiiObject
implements IStepFunctionsTask {
    protected SendToQueue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SendToQueue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SendToQueue(IQueue queue, SendToQueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), Objects.requireNonNull(props, "props is required")});
    }

    public StepFunctionsTaskConfig bind(Task _task) {
        return (StepFunctionsTaskConfig)this.jsiiCall("bind", StepFunctionsTaskConfig.class, new Object[]{Objects.requireNonNull(_task, "_task is required")});
    }

    public static final class Builder {
        private final IQueue queue;
        private final SendToQueueProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
            this.props = new SendToQueueProps.Builder();
        }

        public Builder messageBody(TaskInput messageBody) {
            this.props.messageBody(messageBody);
            return this;
        }

        public Builder delay(Duration delay) {
            this.props.delay(delay);
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder messageDeduplicationId(String messageDeduplicationId) {
            this.props.messageDeduplicationId(messageDeduplicationId);
            return this;
        }

        public Builder messageGroupId(String messageGroupId) {
            this.props.messageGroupId(messageGroupId);
            return this;
        }

        public SendToQueue build() {
            return new SendToQueue(this.queue, this.props.build());
        }
    }
}

