/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.CompressionType;
import software.amazon.awscdk.services.stepfunctions.tasks.DataSource;
import software.amazon.awscdk.services.stepfunctions.tasks.InputMode;
import software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType;
import software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface Channel
extends JsiiSerializable {
    public String getChannelName();

    public DataSource getDataSource();

    public CompressionType getCompressionType();

    public String getContentType();

    public InputMode getInputMode();

    public RecordWrapperType getRecordWrapperType();

    public ShuffleConfig getShuffleConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _channelName;
        private DataSource _dataSource;
        @Nullable
        private CompressionType _compressionType;
        @Nullable
        private String _contentType;
        @Nullable
        private InputMode _inputMode;
        @Nullable
        private RecordWrapperType _recordWrapperType;
        @Nullable
        private ShuffleConfig _shuffleConfig;

        public Builder withChannelName(String value) {
            this._channelName = Objects.requireNonNull(value, "channelName is required");
            return this;
        }

        public Builder withDataSource(DataSource value) {
            this._dataSource = Objects.requireNonNull(value, "dataSource is required");
            return this;
        }

        public Builder withCompressionType(@Nullable CompressionType value) {
            this._compressionType = value;
            return this;
        }

        public Builder withContentType(@Nullable String value) {
            this._contentType = value;
            return this;
        }

        public Builder withInputMode(@Nullable InputMode value) {
            this._inputMode = value;
            return this;
        }

        public Builder withRecordWrapperType(@Nullable RecordWrapperType value) {
            this._recordWrapperType = value;
            return this;
        }

        public Builder withShuffleConfig(@Nullable ShuffleConfig value) {
            this._shuffleConfig = value;
            return this;
        }

        public Channel build() {
            return new Channel(){
                private final String $channelName;
                private final DataSource $dataSource;
                @Nullable
                private final CompressionType $compressionType;
                @Nullable
                private final String $contentType;
                @Nullable
                private final InputMode $inputMode;
                @Nullable
                private final RecordWrapperType $recordWrapperType;
                @Nullable
                private final ShuffleConfig $shuffleConfig;
                {
                    this.$channelName = Objects.requireNonNull(_channelName, "channelName is required");
                    this.$dataSource = Objects.requireNonNull(_dataSource, "dataSource is required");
                    this.$compressionType = _compressionType;
                    this.$contentType = _contentType;
                    this.$inputMode = _inputMode;
                    this.$recordWrapperType = _recordWrapperType;
                    this.$shuffleConfig = _shuffleConfig;
                }

                @Override
                public String getChannelName() {
                    return this.$channelName;
                }

                @Override
                public DataSource getDataSource() {
                    return this.$dataSource;
                }

                @Override
                public CompressionType getCompressionType() {
                    return this.$compressionType;
                }

                @Override
                public String getContentType() {
                    return this.$contentType;
                }

                @Override
                public InputMode getInputMode() {
                    return this.$inputMode;
                }

                @Override
                public RecordWrapperType getRecordWrapperType() {
                    return this.$recordWrapperType;
                }

                @Override
                public ShuffleConfig getShuffleConfig() {
                    return this.$shuffleConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("channelName", om.valueToTree((Object)this.getChannelName()));
                    obj.set("dataSource", om.valueToTree((Object)this.getDataSource()));
                    if (this.getCompressionType() != null) {
                        obj.set("compressionType", om.valueToTree((Object)this.getCompressionType()));
                    }
                    if (this.getContentType() != null) {
                        obj.set("contentType", om.valueToTree((Object)this.getContentType()));
                    }
                    if (this.getInputMode() != null) {
                        obj.set("inputMode", om.valueToTree((Object)this.getInputMode()));
                    }
                    if (this.getRecordWrapperType() != null) {
                        obj.set("recordWrapperType", om.valueToTree((Object)this.getRecordWrapperType()));
                    }
                    if (this.getShuffleConfig() != null) {
                        obj.set("shuffleConfig", om.valueToTree((Object)this.getShuffleConfig()));
                    }
                    return obj;
                }
            };
        }
    }
}

