/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.stepfunctions.tasks.S3Location;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface OutputDataConfig
extends JsiiSerializable {
    public S3Location getS3OutputLocation();

    public IKey getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private S3Location _s3OutputLocation;
        @Nullable
        private IKey _encryptionKey;

        public Builder withS3OutputLocation(S3Location value) {
            this._s3OutputLocation = Objects.requireNonNull(value, "s3OutputLocation is required");
            return this;
        }

        public Builder withEncryptionKey(@Nullable IKey value) {
            this._encryptionKey = value;
            return this;
        }

        public OutputDataConfig build() {
            return new OutputDataConfig(){
                private final S3Location $s3OutputLocation;
                @Nullable
                private final IKey $encryptionKey;
                {
                    this.$s3OutputLocation = Objects.requireNonNull(_s3OutputLocation, "s3OutputLocation is required");
                    this.$encryptionKey = _encryptionKey;
                }

                @Override
                public S3Location getS3OutputLocation() {
                    return this.$s3OutputLocation;
                }

                @Override
                public IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("s3OutputLocation", om.valueToTree((Object)this.getS3OutputLocation()));
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    }
                    return obj;
                }
            };
        }
    }
}

