/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface OutputDataConfig
extends JsiiSerializable {
    public String getS3OutputPath();

    public IKey getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _s3OutputPath;
        @Nullable
        private IKey _encryptionKey;

        public Builder withS3OutputPath(String value) {
            this._s3OutputPath = Objects.requireNonNull(value, "s3OutputPath is required");
            return this;
        }

        public Builder withEncryptionKey(@Nullable IKey value) {
            this._encryptionKey = value;
            return this;
        }

        public OutputDataConfig build() {
            return new OutputDataConfig(){
                private final String $s3OutputPath;
                @Nullable
                private final IKey $encryptionKey;
                {
                    this.$s3OutputPath = Objects.requireNonNull(_s3OutputPath, "s3OutputPath is required");
                    this.$encryptionKey = _encryptionKey;
                }

                @Override
                public String getS3OutputPath() {
                    return this.$s3OutputPath;
                }

                @Override
                public IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("s3OutputPath", om.valueToTree((Object)this.getS3OutputPath()));
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    }
                    return obj;
                }
            };
        }
    }
}

