/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.kms.Key;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TransformResources
extends JsiiSerializable {
    public Number getInstanceCount();

    public InstanceType getInstanceType();

    public Key getVolumeKmsKeyId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _instanceCount;
        private InstanceType _instanceType;
        @Nullable
        private Key _volumeKmsKeyId;

        public Builder withInstanceCount(Number value) {
            this._instanceCount = Objects.requireNonNull(value, "instanceCount is required");
            return this;
        }

        public Builder withInstanceType(InstanceType value) {
            this._instanceType = Objects.requireNonNull(value, "instanceType is required");
            return this;
        }

        public Builder withVolumeKmsKeyId(@Nullable Key value) {
            this._volumeKmsKeyId = value;
            return this;
        }

        public TransformResources build() {
            return new TransformResources(){
                private final Number $instanceCount;
                private final InstanceType $instanceType;
                @Nullable
                private final Key $volumeKmsKeyId;
                {
                    this.$instanceCount = Objects.requireNonNull(_instanceCount, "instanceCount is required");
                    this.$instanceType = Objects.requireNonNull(_instanceType, "instanceType is required");
                    this.$volumeKmsKeyId = _volumeKmsKeyId;
                }

                @Override
                public Number getInstanceCount() {
                    return this.$instanceCount;
                }

                @Override
                public InstanceType getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public Key getVolumeKmsKeyId() {
                    return this.$volumeKmsKeyId;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("instanceCount", om.valueToTree((Object)this.getInstanceCount()));
                    obj.set("instanceType", om.valueToTree((Object)this.getInstanceType()));
                    if (this.getVolumeKmsKeyId() != null) {
                        obj.set("volumeKmsKeyId", om.valueToTree((Object)this.getVolumeKmsKeyId()));
                    }
                    return obj;
                }
            };
        }
    }
}

