/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SendToQueueProps
extends JsiiSerializable {
    public TaskInput getMessageBody();

    public Number getDelaySeconds();

    public String getMessageDeduplicationId();

    public String getMessageGroupId();

    public Boolean getWaitForTaskToken();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TaskInput _messageBody;
        @Nullable
        private Number _delaySeconds;
        @Nullable
        private String _messageDeduplicationId;
        @Nullable
        private String _messageGroupId;
        @Nullable
        private Boolean _waitForTaskToken;

        public Builder withMessageBody(TaskInput value) {
            this._messageBody = Objects.requireNonNull(value, "messageBody is required");
            return this;
        }

        public Builder withDelaySeconds(@Nullable Number value) {
            this._delaySeconds = value;
            return this;
        }

        public Builder withMessageDeduplicationId(@Nullable String value) {
            this._messageDeduplicationId = value;
            return this;
        }

        public Builder withMessageGroupId(@Nullable String value) {
            this._messageGroupId = value;
            return this;
        }

        public Builder withWaitForTaskToken(@Nullable Boolean value) {
            this._waitForTaskToken = value;
            return this;
        }

        public SendToQueueProps build() {
            return new SendToQueueProps(){
                private final TaskInput $messageBody;
                @Nullable
                private final Number $delaySeconds;
                @Nullable
                private final String $messageDeduplicationId;
                @Nullable
                private final String $messageGroupId;
                @Nullable
                private final Boolean $waitForTaskToken;
                {
                    this.$messageBody = Objects.requireNonNull(_messageBody, "messageBody is required");
                    this.$delaySeconds = _delaySeconds;
                    this.$messageDeduplicationId = _messageDeduplicationId;
                    this.$messageGroupId = _messageGroupId;
                    this.$waitForTaskToken = _waitForTaskToken;
                }

                @Override
                public TaskInput getMessageBody() {
                    return this.$messageBody;
                }

                @Override
                public Number getDelaySeconds() {
                    return this.$delaySeconds;
                }

                @Override
                public String getMessageDeduplicationId() {
                    return this.$messageDeduplicationId;
                }

                @Override
                public String getMessageGroupId() {
                    return this.$messageGroupId;
                }

                @Override
                public Boolean getWaitForTaskToken() {
                    return this.$waitForTaskToken;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("messageBody", om.valueToTree((Object)this.getMessageBody()));
                    if (this.getDelaySeconds() != null) {
                        obj.set("delaySeconds", om.valueToTree((Object)this.getDelaySeconds()));
                    }
                    if (this.getMessageDeduplicationId() != null) {
                        obj.set("messageDeduplicationId", om.valueToTree((Object)this.getMessageDeduplicationId()));
                    }
                    if (this.getMessageGroupId() != null) {
                        obj.set("messageGroupId", om.valueToTree((Object)this.getMessageGroupId()));
                    }
                    if (this.getWaitForTaskToken() != null) {
                        obj.set("waitForTaskToken", om.valueToTree((Object)this.getWaitForTaskToken()));
                    }
                    return obj;
                }
            };
        }
    }
}

