/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnAssociation;
import software.amazon.awscdk.services.ssm.CfnAssociationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation")
public class CfnAssociation
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAssociation.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAssociation(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssociation(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAssociation(@NotNull Construct scope, @NotNull String id, @NotNull CfnAssociationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAssociationId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrAssociationId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getApplyOnlyAtCronInterval() {
        return Kernel.get((Object)((Object)this), (String)"applyOnlyAtCronInterval", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplyOnlyAtCronInterval(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"applyOnlyAtCronInterval", (Object)value);
    }

    public void setApplyOnlyAtCronInterval(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"applyOnlyAtCronInterval", (Object)value);
    }

    @Nullable
    public String getAssociationName() {
        return (String)Kernel.get((Object)((Object)this), (String)"associationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAssociationName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"associationName", (Object)value);
    }

    @Nullable
    public String getAutomationTargetParameterName() {
        return (String)Kernel.get((Object)((Object)this), (String)"automationTargetParameterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutomationTargetParameterName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"automationTargetParameterName", (Object)value);
    }

    @Nullable
    public String getComplianceSeverity() {
        return (String)Kernel.get((Object)((Object)this), (String)"complianceSeverity", (NativeType)NativeType.forClass(String.class));
    }

    public void setComplianceSeverity(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"complianceSeverity", (Object)value);
    }

    @Nullable
    public String getDocumentVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"documentVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setDocumentVersion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"documentVersion", (Object)value);
    }

    @Nullable
    public String getInstanceId() {
        return (String)Kernel.get((Object)((Object)this), (String)"instanceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"instanceId", (Object)value);
    }

    @Nullable
    public String getMaxConcurrency() {
        return (String)Kernel.get((Object)((Object)this), (String)"maxConcurrency", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaxConcurrency(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"maxConcurrency", (Object)value);
    }

    @Nullable
    public String getMaxErrors() {
        return (String)Kernel.get((Object)((Object)this), (String)"maxErrors", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaxErrors(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"maxErrors", (Object)value);
    }

    @Nullable
    public Object getOutputLocation() {
        return Kernel.get((Object)((Object)this), (String)"outputLocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutputLocation(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"outputLocation", (Object)value);
    }

    public void setOutputLocation(@Nullable InstanceAssociationOutputLocationProperty value) {
        Kernel.set((Object)((Object)this), (String)"outputLocation", (Object)value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)((Object)this), (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"parameters", (Object)value);
    }

    public void setParameters(@Nullable Map<String, List<String>> value) {
        Kernel.set((Object)((Object)this), (String)"parameters", value);
    }

    @Nullable
    public String getScheduleExpression() {
        return (String)Kernel.get((Object)((Object)this), (String)"scheduleExpression", (NativeType)NativeType.forClass(String.class));
    }

    public void setScheduleExpression(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"scheduleExpression", (Object)value);
    }

    @Nullable
    public String getSyncCompliance() {
        return (String)Kernel.get((Object)((Object)this), (String)"syncCompliance", (NativeType)NativeType.forClass(String.class));
    }

    public void setSyncCompliance(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"syncCompliance", (Object)value);
    }

    @Nullable
    public Object getTargets() {
        return Kernel.get((Object)((Object)this), (String)"targets", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTargets(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"targets", (Object)value);
    }

    public void setTargets(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"targets", value);
    }

    @Nullable
    public Number getWaitForSuccessTimeoutSeconds() {
        return (Number)Kernel.get((Object)((Object)this), (String)"waitForSuccessTimeoutSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setWaitForSuccessTimeoutSeconds(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"waitForSuccessTimeoutSeconds", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAssociation> {
        private final Construct scope;
        private final String id;
        private final CfnAssociationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAssociationProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }

        public Builder applyOnlyAtCronInterval(IResolvable applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }

        public Builder associationName(String associationName) {
            this.props.associationName(associationName);
            return this;
        }

        public Builder automationTargetParameterName(String automationTargetParameterName) {
            this.props.automationTargetParameterName(automationTargetParameterName);
            return this;
        }

        public Builder complianceSeverity(String complianceSeverity) {
            this.props.complianceSeverity(complianceSeverity);
            return this;
        }

        public Builder documentVersion(String documentVersion) {
            this.props.documentVersion(documentVersion);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        public Builder maxConcurrency(String maxConcurrency) {
            this.props.maxConcurrency(maxConcurrency);
            return this;
        }

        public Builder maxErrors(String maxErrors) {
            this.props.maxErrors(maxErrors);
            return this;
        }

        public Builder outputLocation(IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder outputLocation(InstanceAssociationOutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, ? extends List<String>> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder scheduleExpression(String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        public Builder syncCompliance(String syncCompliance) {
            this.props.syncCompliance(syncCompliance);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder targets(List<? extends Object> targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder waitForSuccessTimeoutSeconds(Number waitForSuccessTimeoutSeconds) {
            this.props.waitForSuccessTimeoutSeconds(waitForSuccessTimeoutSeconds);
            return this;
        }

        public CfnAssociation build() {
            return new CfnAssociation(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetProperty> {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TargetProperty build() {
                return new Jsii.Proxy(this.key, this.values);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.S3OutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOutputS3BucketName() {
            return null;
        }

        @Nullable
        default public String getOutputS3KeyPrefix() {
            return null;
        }

        @Nullable
        default public String getOutputS3Region() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OutputLocationProperty> {
            private String outputS3BucketName;
            private String outputS3KeyPrefix;
            private String outputS3Region;

            public Builder outputS3BucketName(String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            public Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            public Builder outputS3Region(String outputS3Region) {
                this.outputS3Region = outputS3Region;
                return this;
            }

            public S3OutputLocationProperty build() {
                return new Jsii.Proxy(this.outputS3BucketName, this.outputS3KeyPrefix, this.outputS3Region);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.ParameterValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getParameterValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterValuesProperty> {
            private List<String> parameterValues;

            public Builder parameterValues(List<String> parameterValues) {
                this.parameterValues = parameterValues;
                return this;
            }

            public ParameterValuesProperty build() {
                return new Jsii.Proxy(this.parameterValues);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.InstanceAssociationOutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceAssociationOutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceAssociationOutputLocationProperty> {
            private Object s3Location;

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3OutputLocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public InstanceAssociationOutputLocationProperty build() {
                return new Jsii.Proxy(this.s3Location);
            }
        }
    }
}

