/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnPatchBaseline;
import software.amazon.awscdk.services.ssm.CfnPatchBaselineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline")
public class CfnPatchBaseline
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPatchBaseline.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnPatchBaseline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPatchBaseline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPatchBaseline(@NotNull Construct scope, @NotNull String id, @NotNull CfnPatchBaselineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getApprovalRules() {
        return this.jsiiGet("approvalRules", Object.class);
    }

    public void setApprovalRules(@Nullable IResolvable value) {
        this.jsiiSet("approvalRules", value);
    }

    public void setApprovalRules(@Nullable RuleGroupProperty value) {
        this.jsiiSet("approvalRules", value);
    }

    @Nullable
    public List<String> getApprovedPatches() {
        return Optional.ofNullable((List)this.jsiiGet("approvedPatches", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setApprovedPatches(@Nullable List<String> value) {
        this.jsiiSet("approvedPatches", value);
    }

    @Nullable
    public String getApprovedPatchesComplianceLevel() {
        return (String)this.jsiiGet("approvedPatchesComplianceLevel", String.class);
    }

    public void setApprovedPatchesComplianceLevel(@Nullable String value) {
        this.jsiiSet("approvedPatchesComplianceLevel", value);
    }

    @Nullable
    public Object getApprovedPatchesEnableNonSecurity() {
        return this.jsiiGet("approvedPatchesEnableNonSecurity", Object.class);
    }

    public void setApprovedPatchesEnableNonSecurity(@Nullable Boolean value) {
        this.jsiiSet("approvedPatchesEnableNonSecurity", value);
    }

    public void setApprovedPatchesEnableNonSecurity(@Nullable IResolvable value) {
        this.jsiiSet("approvedPatchesEnableNonSecurity", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getGlobalFilters() {
        return this.jsiiGet("globalFilters", Object.class);
    }

    public void setGlobalFilters(@Nullable IResolvable value) {
        this.jsiiSet("globalFilters", value);
    }

    public void setGlobalFilters(@Nullable PatchFilterGroupProperty value) {
        this.jsiiSet("globalFilters", value);
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.jsiiGet("operatingSystem", String.class);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.jsiiSet("operatingSystem", value);
    }

    @Nullable
    public List<String> getPatchGroups() {
        return Optional.ofNullable((List)this.jsiiGet("patchGroups", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPatchGroups(@Nullable List<String> value) {
        this.jsiiSet("patchGroups", value);
    }

    @Nullable
    public List<String> getRejectedPatches() {
        return Optional.ofNullable((List)this.jsiiGet("rejectedPatches", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setRejectedPatches(@Nullable List<String> value) {
        this.jsiiSet("rejectedPatches", value);
    }

    @Nullable
    public String getRejectedPatchesAction() {
        return (String)this.jsiiGet("rejectedPatchesAction", String.class);
    }

    public void setRejectedPatchesAction(@Nullable String value) {
        this.jsiiSet("rejectedPatchesAction", value);
    }

    @Nullable
    public Object getSources() {
        return this.jsiiGet("sources", Object.class);
    }

    public void setSources(@Nullable IResolvable value) {
        this.jsiiSet("sources", value);
    }

    public void setSources(@Nullable List<Object> value) {
        this.jsiiSet("sources", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnPatchBaselineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPatchBaselineProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder approvalRules(IResolvable approvalRules) {
            this.props.approvalRules(approvalRules);
            return this;
        }

        public Builder approvalRules(RuleGroupProperty approvalRules) {
            this.props.approvalRules(approvalRules);
            return this;
        }

        public Builder approvedPatches(List<String> approvedPatches) {
            this.props.approvedPatches(approvedPatches);
            return this;
        }

        public Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.props.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel);
            return this;
        }

        public Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.props.approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
            return this;
        }

        public Builder approvedPatchesEnableNonSecurity(IResolvable approvedPatchesEnableNonSecurity) {
            this.props.approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder globalFilters(IResolvable globalFilters) {
            this.props.globalFilters(globalFilters);
            return this;
        }

        public Builder globalFilters(PatchFilterGroupProperty globalFilters) {
            this.props.globalFilters(globalFilters);
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.props.operatingSystem(operatingSystem);
            return this;
        }

        public Builder patchGroups(List<String> patchGroups) {
            this.props.patchGroups(patchGroups);
            return this;
        }

        public Builder rejectedPatches(List<String> rejectedPatches) {
            this.props.rejectedPatches(rejectedPatches);
            return this;
        }

        public Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.props.rejectedPatchesAction(rejectedPatchesAction);
            return this;
        }

        public Builder sources(IResolvable sources) {
            this.props.sources(sources);
            return this;
        }

        public Builder sources(List<Object> sources) {
            this.props.sources(sources);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnPatchBaseline build() {
            return new CfnPatchBaseline(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline.RuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getApproveAfterDays() {
            return null;
        }

        @Nullable
        default public String getComplianceLevel() {
            return null;
        }

        @Nullable
        default public Object getEnableNonSecurity() {
            return null;
        }

        @Nullable
        default public Object getPatchFilterGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number approveAfterDays;
            private String complianceLevel;
            private Object enableNonSecurity;
            private Object patchFilterGroup;

            public Builder approveAfterDays(Number approveAfterDays) {
                this.approveAfterDays = approveAfterDays;
                return this;
            }

            public Builder complianceLevel(String complianceLevel) {
                this.complianceLevel = complianceLevel;
                return this;
            }

            public Builder enableNonSecurity(Boolean enableNonSecurity) {
                this.enableNonSecurity = enableNonSecurity;
                return this;
            }

            public Builder enableNonSecurity(IResolvable enableNonSecurity) {
                this.enableNonSecurity = enableNonSecurity;
                return this;
            }

            public Builder patchFilterGroup(IResolvable patchFilterGroup) {
                this.patchFilterGroup = patchFilterGroup;
                return this;
            }

            public Builder patchFilterGroup(PatchFilterGroupProperty patchFilterGroup) {
                this.patchFilterGroup = patchFilterGroup;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this.approveAfterDays, this.complianceLevel, this.enableNonSecurity, this.patchFilterGroup, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline.RuleGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleGroupProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPatchRules() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object patchRules;

            public Builder patchRules(IResolvable patchRules) {
                this.patchRules = patchRules;
                return this;
            }

            public Builder patchRules(List<Object> patchRules) {
                this.patchRules = patchRules;
                return this;
            }

            public RuleGroupProperty build() {
                return new Jsii.Proxy(this.patchRules, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline.PatchSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PatchSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConfiguration() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public List<String> getProducts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String configuration;
            private String name;
            private List<String> products;

            public Builder configuration(String configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder products(List<String> products) {
                this.products = products;
                return this;
            }

            public PatchSourceProperty build() {
                return new Jsii.Proxy(this.configuration, this.name, this.products, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline.PatchFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PatchFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public PatchFilterProperty build() {
                return new Jsii.Proxy(this.key, this.values, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnPatchBaseline.PatchFilterGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PatchFilterGroupProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPatchFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object patchFilters;

            public Builder patchFilters(IResolvable patchFilters) {
                this.patchFilters = patchFilters;
                return this;
            }

            public Builder patchFilters(List<Object> patchFilters) {
                this.patchFilters = patchFilters;
                return this;
            }

            public PatchFilterGroupProperty build() {
                return new Jsii.Proxy(this.patchFilters, null);
            }
        }
    }
}

