/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnAssociation;
import software.amazon.awscdk.services.ssm.CfnAssociationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation")
public class CfnAssociation
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAssociation.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnAssociation(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssociation(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAssociation(@NotNull Construct scope, @NotNull String id, @NotNull CfnAssociationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getAssociationName() {
        return (String)this.jsiiGet("associationName", String.class);
    }

    public void setAssociationName(@Nullable String value) {
        this.jsiiSet("associationName", value);
    }

    @Nullable
    public String getDocumentVersion() {
        return (String)this.jsiiGet("documentVersion", String.class);
    }

    public void setDocumentVersion(@Nullable String value) {
        this.jsiiSet("documentVersion", value);
    }

    @Nullable
    public String getInstanceId() {
        return (String)this.jsiiGet("instanceId", String.class);
    }

    public void setInstanceId(@Nullable String value) {
        this.jsiiSet("instanceId", value);
    }

    @Nullable
    public Object getOutputLocation() {
        return this.jsiiGet("outputLocation", Object.class);
    }

    public void setOutputLocation(@Nullable IResolvable value) {
        this.jsiiSet("outputLocation", value);
    }

    public void setOutputLocation(@Nullable InstanceAssociationOutputLocationProperty value) {
        this.jsiiSet("outputLocation", value);
    }

    @Nullable
    public Object getParameters() {
        return this.jsiiGet("parameters", Object.class);
    }

    public void setParameters(@Nullable IResolvable value) {
        this.jsiiSet("parameters", value);
    }

    public void setParameters(@Nullable Map<String, Object> value) {
        this.jsiiSet("parameters", value);
    }

    @Nullable
    public String getScheduleExpression() {
        return (String)this.jsiiGet("scheduleExpression", String.class);
    }

    public void setScheduleExpression(@Nullable String value) {
        this.jsiiSet("scheduleExpression", value);
    }

    @Nullable
    public Object getTargets() {
        return this.jsiiGet("targets", Object.class);
    }

    public void setTargets(@Nullable IResolvable value) {
        this.jsiiSet("targets", value);
    }

    public void setTargets(@Nullable List<Object> value) {
        this.jsiiSet("targets", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnAssociationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAssociationProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder associationName(String associationName) {
            this.props.associationName(associationName);
            return this;
        }

        public Builder documentVersion(String documentVersion) {
            this.props.documentVersion(documentVersion);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        public Builder outputLocation(IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder outputLocation(InstanceAssociationOutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder scheduleExpression(String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder targets(List<Object> targets) {
            this.props.targets(targets);
            return this;
        }

        public CfnAssociation build() {
            return new CfnAssociation(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TargetProperty build() {
                return new Jsii.Proxy(this.key, this.values, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.S3OutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOutputS3BucketName() {
            return null;
        }

        @Nullable
        default public String getOutputS3KeyPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String outputS3BucketName;
            private String outputS3KeyPrefix;

            public Builder outputS3BucketName(String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            public Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            public S3OutputLocationProperty build() {
                return new Jsii.Proxy(this.outputS3BucketName, this.outputS3KeyPrefix, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.ParameterValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterValuesProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getParameterValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> parameterValues;

            public Builder parameterValues(List<String> parameterValues) {
                this.parameterValues = parameterValues;
                return this;
            }

            public ParameterValuesProperty build() {
                return new Jsii.Proxy(this.parameterValues, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation.InstanceAssociationOutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceAssociationOutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object s3Location;

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3OutputLocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public InstanceAssociationOutputLocationProperty build() {
                return new Jsii.Proxy(this.s3Location, null);
            }
        }
    }
}

