/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.IParameter;
import software.amazon.awscdk.services.ssm.IStringListParameter;
import software.amazon.awscdk.services.ssm.ParameterTier;
import software.amazon.awscdk.services.ssm.StringListParameterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.StringListParameter")
public class StringListParameter
extends Resource
implements IStringListParameter,
IParameter {
    protected StringListParameter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringListParameter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StringListParameter(@NotNull Construct scope, @NotNull String id, @NotNull StringListParameterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IStringListParameter fromStringListParameterName(@NotNull Construct scope, @NotNull String id, @NotNull String stringListParameterName) {
        return (IStringListParameter)JsiiObject.jsiiStaticCall(StringListParameter.class, (String)"fromStringListParameterName", IStringListParameter.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(stringListParameterName, "stringListParameterName is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public String getParameterArn() {
        return (String)this.jsiiGet("parameterArn", String.class);
    }

    @Override
    @NotNull
    public String getParameterName() {
        return (String)this.jsiiGet("parameterName", String.class);
    }

    @Override
    @NotNull
    public String getParameterType() {
        return (String)this.jsiiGet("parameterType", String.class);
    }

    @Override
    @NotNull
    public List<String> getStringListValue() {
        return Collections.unmodifiableList((List)this.jsiiGet("stringListValue", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final StringListParameterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new StringListParameterProps.Builder();
        }

        public Builder allowedPattern(String allowedPattern) {
            this.props.allowedPattern(allowedPattern);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder parameterName(String parameterName) {
            this.props.parameterName(parameterName);
            return this;
        }

        public Builder simpleName(Boolean simpleName) {
            this.props.simpleName(simpleName);
            return this;
        }

        public Builder tier(ParameterTier tier) {
            this.props.tier(tier);
            return this;
        }

        public Builder stringListValue(List<String> stringListValue) {
            this.props.stringListValue(stringListValue);
            return this;
        }

        public StringListParameter build() {
            return new StringListParameter(this.scope, this.id, this.props.build());
        }
    }
}

