/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnResourceDataSync;
import software.amazon.awscdk.services.ssm.CfnResourceDataSyncProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync")
public class CfnResourceDataSync
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnResourceDataSync.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnResourceDataSync(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceDataSync(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnResourceDataSync(@NotNull Construct scope, @NotNull String id, @NotNull CfnResourceDataSyncProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrSyncName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrSyncName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getSyncName() {
        return (String)Kernel.get((Object)((Object)this), (String)"syncName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSyncName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"syncName", (Object)Objects.requireNonNull(value, "syncName is required"));
    }

    @Nullable
    public String getBucketName() {
        return (String)Kernel.get((Object)((Object)this), (String)"bucketName", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucketName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"bucketName", (Object)value);
    }

    @Nullable
    public String getBucketPrefix() {
        return (String)Kernel.get((Object)((Object)this), (String)"bucketPrefix", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucketPrefix(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"bucketPrefix", (Object)value);
    }

    @Nullable
    public String getBucketRegion() {
        return (String)Kernel.get((Object)((Object)this), (String)"bucketRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucketRegion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"bucketRegion", (Object)value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"kmsKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"kmsKeyArn", (Object)value);
    }

    @Nullable
    public Object getS3Destination() {
        return Kernel.get((Object)((Object)this), (String)"s3Destination", (NativeType)NativeType.forClass(Object.class));
    }

    public void setS3Destination(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"s3Destination", (Object)value);
    }

    public void setS3Destination(@Nullable S3DestinationProperty value) {
        Kernel.set((Object)((Object)this), (String)"s3Destination", (Object)value);
    }

    @Nullable
    public String getSyncFormat() {
        return (String)Kernel.get((Object)((Object)this), (String)"syncFormat", (NativeType)NativeType.forClass(String.class));
    }

    public void setSyncFormat(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"syncFormat", (Object)value);
    }

    @Nullable
    public Object getSyncSource() {
        return Kernel.get((Object)((Object)this), (String)"syncSource", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSyncSource(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"syncSource", (Object)value);
    }

    public void setSyncSource(@Nullable SyncSourceProperty value) {
        Kernel.set((Object)((Object)this), (String)"syncSource", (Object)value);
    }

    @Nullable
    public String getSyncType() {
        return (String)Kernel.get((Object)((Object)this), (String)"syncType", (NativeType)NativeType.forClass(String.class));
    }

    public void setSyncType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"syncType", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnResourceDataSync> {
        private final Construct scope;
        private final String id;
        private final CfnResourceDataSyncProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnResourceDataSyncProps.Builder();
        }

        public Builder syncName(String syncName) {
            this.props.syncName(syncName);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        public Builder bucketPrefix(String bucketPrefix) {
            this.props.bucketPrefix(bucketPrefix);
            return this;
        }

        public Builder bucketRegion(String bucketRegion) {
            this.props.bucketRegion(bucketRegion);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder s3Destination(IResolvable s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        public Builder s3Destination(S3DestinationProperty s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        public Builder syncFormat(String syncFormat) {
            this.props.syncFormat(syncFormat);
            return this;
        }

        public Builder syncSource(IResolvable syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }

        public Builder syncSource(SyncSourceProperty syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }

        public Builder syncType(String syncType) {
            this.props.syncType(syncType);
            return this;
        }

        public CfnResourceDataSync build() {
            return new CfnResourceDataSync(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.SyncSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SyncSourceProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSourceRegions();

        @NotNull
        public String getSourceType();

        @Nullable
        default public Object getAwsOrganizationsSource() {
            return null;
        }

        @Nullable
        default public Object getIncludeFutureRegions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SyncSourceProperty> {
            List<String> sourceRegions;
            String sourceType;
            Object awsOrganizationsSource;
            Object includeFutureRegions;

            public Builder sourceRegions(List<String> sourceRegions) {
                this.sourceRegions = sourceRegions;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder awsOrganizationsSource(IResolvable awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            public Builder awsOrganizationsSource(AwsOrganizationsSourceProperty awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            public Builder includeFutureRegions(Boolean includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            public Builder includeFutureRegions(IResolvable includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            public SyncSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.S3DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getBucketRegion();

        @NotNull
        public String getSyncFormat();

        @Nullable
        default public String getBucketPrefix() {
            return null;
        }

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DestinationProperty> {
            String bucketName;
            String bucketRegion;
            String syncFormat;
            String bucketPrefix;
            String kmsKeyArn;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder bucketRegion(String bucketRegion) {
                this.bucketRegion = bucketRegion;
                return this;
            }

            public Builder syncFormat(String syncFormat) {
                this.syncFormat = syncFormat;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public S3DestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsOrganizationsSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getOrganizationSourceType();

        @Nullable
        default public List<String> getOrganizationalUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsOrganizationsSourceProperty> {
            String organizationSourceType;
            List<String> organizationalUnits;

            public Builder organizationSourceType(String organizationSourceType) {
                this.organizationSourceType = organizationSourceType;
                return this;
            }

            public Builder organizationalUnits(List<String> organizationalUnits) {
                this.organizationalUnits = organizationalUnits;
                return this;
            }

            public AwsOrganizationsSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

