package software.amazon.awscdk.services.ssm;

/**
 * Attributes for secure string parameters.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-01T11:10:47.310Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ssm.$Module.class, fqn = "@aws-cdk/aws-ssm.SecureStringParameterAttributes")
@software.amazon.jsii.Jsii.Proxy(SecureStringParameterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecureStringParameterAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ssm.CommonStringParameterAttributes {

    /**
     * The version number of the value you wish to retrieve.
     * <p>
     * This is required for secure strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getVersion();

    /**
     * The encryption key that is used to encrypt this parameter.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecureStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecureStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecureStringParameterAttributes> {
        private java.lang.Number version;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.lang.String parameterName;
        private java.lang.Boolean simpleName;

        /**
         * Sets the value of {@link SecureStringParameterAttributes#getVersion}
         * @param version The version number of the value you wish to retrieve. This parameter is required.
         *                This is required for secure strings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.Number version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link SecureStringParameterAttributes#getEncryptionKey}
         * @param encryptionKey The encryption key that is used to encrypt this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link SecureStringParameterAttributes#getParameterName}
         * @param parameterName The name of the parameter store value. This parameter is required.
         *                      This value can be a token or a concrete string. If it is a concrete string
         *                      and includes "/" it must also be prefixed with a "/" (fully-qualified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link SecureStringParameterAttributes#getSimpleName}
         * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
         *                   This is only required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecureStringParameterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecureStringParameterAttributes build() {
            return new Jsii$Proxy(version, encryptionKey, parameterName, simpleName);
        }
    }

    /**
     * An implementation for {@link SecureStringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecureStringParameterAttributes {
        private final java.lang.Number version;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number version, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.lang.String parameterName, final java.lang.Boolean simpleName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(version, "version is required");
            this.encryptionKey = encryptionKey;
            this.parameterName = java.util.Objects.requireNonNull(parameterName, "parameterName is required");
            this.simpleName = simpleName;
        }

        @Override
        public final java.lang.Number getVersion() {
            return this.version;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            data.set("parameterName", om.valueToTree(this.getParameterName()));
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ssm.SecureStringParameterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecureStringParameterAttributes.Jsii$Proxy that = (SecureStringParameterAttributes.Jsii$Proxy) o;

            if (!version.equals(that.version)) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (!parameterName.equals(that.parameterName)) return false;
            return this.simpleName != null ? this.simpleName.equals(that.simpleName) : that.simpleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.parameterName.hashCode());
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            return result;
        }
    }
}
