/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnDocumentProps
extends JsiiSerializable {
    public Object getContent();

    public String getDocumentType();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _content;
        @Nullable
        private String _documentType;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withContent(ObjectNode value) {
            this._content = Objects.requireNonNull(value, "content is required");
            return this;
        }

        public Builder withContent(Token value) {
            this._content = Objects.requireNonNull(value, "content is required");
            return this;
        }

        public Builder withDocumentType(@Nullable String value) {
            this._documentType = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnDocumentProps build() {
            return new CfnDocumentProps(){
                private final Object $content;
                @Nullable
                private final String $documentType;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$content = Objects.requireNonNull(_content, "content is required");
                    this.$documentType = _documentType;
                    this.$tags = _tags;
                }

                @Override
                public Object getContent() {
                    return this.$content;
                }

                @Override
                public String getDocumentType() {
                    return this.$documentType;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("content", om.valueToTree(this.getContent()));
                    obj.set("documentType", om.valueToTree((Object)this.getDocumentType()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    return obj;
                }
            };
        }
    }
}

