/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sqs;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.services.autoscaling.api.ILifecycleHook;
import software.amazon.awscdk.services.autoscaling.api.LifecycleHookTargetProps;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricCustomization;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps;
import software.amazon.awscdk.services.sqs.;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.sqs.QueueImportProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sqs.QueueBase")
public abstract class QueueBase
extends Construct
implements IQueue {
    protected QueueBase(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    @Override
    public void addToResourcePolicy(PolicyStatement statement) {
        this.jsiiCall("addToResourcePolicy", Void.class, Stream.of(Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    public BucketNotificationDestinationProps asBucketNotificationDestination(String bucketArn, String bucketId) {
        return (BucketNotificationDestinationProps)this.jsiiCall("asBucketNotificationDestination", BucketNotificationDestinationProps.class, Stream.concat(Stream.of(Objects.requireNonNull(bucketArn, "bucketArn is required")), Stream.of(Objects.requireNonNull(bucketId, "bucketId is required"))).toArray());
    }

    public LifecycleHookTargetProps asLifecycleHookTarget(ILifecycleHook lifecycleHook) {
        return (LifecycleHookTargetProps)this.jsiiCall("asLifecycleHookTarget", LifecycleHookTargetProps.class, Stream.of(Objects.requireNonNull(lifecycleHook, "lifecycleHook is required")).toArray());
    }

    @Override
    public abstract QueueImportProps export();

    @Override
    public void grant(@Nullable IPrincipal identity, String ... queueActions) {
        this.jsiiCall("grant", Void.class, Stream.concat(Stream.of(identity), Arrays.stream((Object[])Objects.requireNonNull(queueActions, "queueActions is required"))).toArray());
    }

    @Override
    public void grantConsumeMessages(@Nullable IPrincipal identity) {
        this.jsiiCall("grantConsumeMessages", Void.class, Stream.of(identity).toArray());
    }

    @Override
    public void grantConsumeMessages() {
        this.jsiiCall("grantConsumeMessages", Void.class, new Object[0]);
    }

    @Override
    public void grantPurge(@Nullable IPrincipal identity) {
        this.jsiiCall("grantPurge", Void.class, Stream.of(identity).toArray());
    }

    @Override
    public void grantPurge() {
        this.jsiiCall("grantPurge", Void.class, new Object[0]);
    }

    @Override
    public void grantSendMessages(@Nullable IPrincipal identity) {
        this.jsiiCall("grantSendMessages", Void.class, Stream.of(identity).toArray());
    }

    @Override
    public void grantSendMessages() {
        this.jsiiCall("grantSendMessages", Void.class, new Object[0]);
    }

    @Override
    public Metric metric(String metricName, @Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metric", Metric.class, Stream.concat(Stream.of(Objects.requireNonNull(metricName, "metricName is required")), Stream.of(props)).toArray());
    }

    @Override
    public Metric metric(String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, Stream.of(Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    @Override
    public Metric metricApproximateAgeOfOldestMessage(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricApproximateAgeOfOldestMessage", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricApproximateAgeOfOldestMessage() {
        return (Metric)this.jsiiCall("metricApproximateAgeOfOldestMessage", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricApproximateNumberOfMessagesDelayed(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesDelayed", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricApproximateNumberOfMessagesDelayed() {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesDelayed", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricApproximateNumberOfMessagesNotVisible(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricApproximateNumberOfMessagesNotVisible() {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricApproximateNumberOfMessagesVisible(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesVisible", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricApproximateNumberOfMessagesVisible() {
        return (Metric)this.jsiiCall("metricApproximateNumberOfMessagesVisible", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricNumberOfEmptyReceives(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricNumberOfEmptyReceives", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricNumberOfEmptyReceives() {
        return (Metric)this.jsiiCall("metricNumberOfEmptyReceives", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricNumberOfMessagesDeleted(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricNumberOfMessagesDeleted", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricNumberOfMessagesDeleted() {
        return (Metric)this.jsiiCall("metricNumberOfMessagesDeleted", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricNumberOfMessagesReceived(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricNumberOfMessagesReceived", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricNumberOfMessagesReceived() {
        return (Metric)this.jsiiCall("metricNumberOfMessagesReceived", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricNumberOfMessagesSent(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricNumberOfMessagesSent", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricNumberOfMessagesSent() {
        return (Metric)this.jsiiCall("metricNumberOfMessagesSent", Metric.class, new Object[0]);
    }

    @Override
    public Metric metricSentMessageSize(@Nullable MetricCustomization props) {
        return (Metric)this.jsiiCall("metricSentMessageSize", Metric.class, Stream.of(props).toArray());
    }

    @Override
    public Metric metricSentMessageSize() {
        return (Metric)this.jsiiCall("metricSentMessageSize", Metric.class, new Object[0]);
    }

    protected Boolean getAutoCreatePolicy() {
        return (Boolean)this.jsiiGet("autoCreatePolicy", Boolean.class);
    }

    @Override
    public String getQueueArn() {
        return (String)this.jsiiGet("queueArn", String.class);
    }

    @Override
    public String getQueueName() {
        return (String)this.jsiiGet("queueName", String.class);
    }

    @Override
    public String getQueueUrl() {
        return (String)this.jsiiGet("queueUrl", String.class);
    }

    @Override
    @Nullable
    public IEncryptionKey getEncryptionMasterKey() {
        return (IEncryptionKey)this.jsiiGet("encryptionMasterKey", IEncryptionKey.class);
    }
}

