/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sns.;
import software.amazon.awscdk.services.sns.CfnSubscriptionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sns.CfnSubscription")
public class CfnSubscription
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSubscription.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSubscription(@NotNull Construct scope, @NotNull String id, @NotNull CfnSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnSubscription fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnSubscription)((Object)JsiiObject.jsiiStaticCall(CfnSubscription.class, (String)"fromCloudFormation", CfnSubscription.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDeliveryPolicy() {
        return this.jsiiGet("deliveryPolicy", Object.class);
    }

    public void setDeliveryPolicy(@NotNull Object value) {
        this.jsiiSet("deliveryPolicy", Objects.requireNonNull(value, "deliveryPolicy is required"));
    }

    @NotNull
    public Object getFilterPolicy() {
        return this.jsiiGet("filterPolicy", Object.class);
    }

    public void setFilterPolicy(@NotNull Object value) {
        this.jsiiSet("filterPolicy", Objects.requireNonNull(value, "filterPolicy is required"));
    }

    @NotNull
    public String getProtocol() {
        return (String)this.jsiiGet("protocol", String.class);
    }

    public void setProtocol(@NotNull String value) {
        this.jsiiSet("protocol", Objects.requireNonNull(value, "protocol is required"));
    }

    @NotNull
    public Object getRedrivePolicy() {
        return this.jsiiGet("redrivePolicy", Object.class);
    }

    public void setRedrivePolicy(@NotNull Object value) {
        this.jsiiSet("redrivePolicy", Objects.requireNonNull(value, "redrivePolicy is required"));
    }

    @NotNull
    public String getTopicArn() {
        return (String)this.jsiiGet("topicArn", String.class);
    }

    public void setTopicArn(@NotNull String value) {
        this.jsiiSet("topicArn", Objects.requireNonNull(value, "topicArn is required"));
    }

    @Nullable
    public String getEndpoint() {
        return (String)this.jsiiGet("endpoint", String.class);
    }

    public void setEndpoint(@Nullable String value) {
        this.jsiiSet("endpoint", value);
    }

    @Nullable
    public Object getRawMessageDelivery() {
        return this.jsiiGet("rawMessageDelivery", Object.class);
    }

    public void setRawMessageDelivery(@Nullable Boolean value) {
        this.jsiiSet("rawMessageDelivery", value);
    }

    public void setRawMessageDelivery(@Nullable IResolvable value) {
        this.jsiiSet("rawMessageDelivery", value);
    }

    @Nullable
    public String getRegion() {
        return (String)this.jsiiGet("region", String.class);
    }

    public void setRegion(@Nullable String value) {
        this.jsiiSet("region", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnSubscriptionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnSubscriptionProps.Builder();
        }

        public Builder protocol(String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder topicArn(String topicArn) {
            this.props.topicArn(topicArn);
            return this;
        }

        public Builder deliveryPolicy(Object deliveryPolicy) {
            this.props.deliveryPolicy(deliveryPolicy);
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder filterPolicy(Object filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder rawMessageDelivery(IResolvable rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder redrivePolicy(Object redrivePolicy) {
            this.props.redrivePolicy(redrivePolicy);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public CfnSubscription build() {
            return new CfnSubscription(this.scope, this.id, this.props.build());
        }
    }
}

