/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sns.;
import software.amazon.awscdk.services.sns.CfnSubscriptionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sns.CfnSubscription")
public class CfnSubscription
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSubscription.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSubscription(@NotNull Construct scope, @NotNull String id, @NotNull CfnSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDeliveryPolicy() {
        return Kernel.get((Object)((Object)this), (String)"deliveryPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeliveryPolicy(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"deliveryPolicy", (Object)Objects.requireNonNull(value, "deliveryPolicy is required"));
    }

    @NotNull
    public Object getFilterPolicy() {
        return Kernel.get((Object)((Object)this), (String)"filterPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFilterPolicy(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"filterPolicy", (Object)Objects.requireNonNull(value, "filterPolicy is required"));
    }

    @NotNull
    public String getProtocol() {
        return (String)Kernel.get((Object)((Object)this), (String)"protocol", (NativeType)NativeType.forClass(String.class));
    }

    public void setProtocol(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"protocol", (Object)Objects.requireNonNull(value, "protocol is required"));
    }

    @NotNull
    public Object getRedrivePolicy() {
        return Kernel.get((Object)((Object)this), (String)"redrivePolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRedrivePolicy(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"redrivePolicy", (Object)Objects.requireNonNull(value, "redrivePolicy is required"));
    }

    @NotNull
    public String getTopicArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"topicArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setTopicArn(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"topicArn", (Object)Objects.requireNonNull(value, "topicArn is required"));
    }

    @Nullable
    public String getEndpoint() {
        return (String)Kernel.get((Object)((Object)this), (String)"endpoint", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpoint(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"endpoint", (Object)value);
    }

    @Nullable
    public String getFilterPolicyScope() {
        return (String)Kernel.get((Object)((Object)this), (String)"filterPolicyScope", (NativeType)NativeType.forClass(String.class));
    }

    public void setFilterPolicyScope(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"filterPolicyScope", (Object)value);
    }

    @Nullable
    public Object getRawMessageDelivery() {
        return Kernel.get((Object)((Object)this), (String)"rawMessageDelivery", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRawMessageDelivery(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"rawMessageDelivery", (Object)value);
    }

    public void setRawMessageDelivery(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"rawMessageDelivery", (Object)value);
    }

    @Nullable
    public String getRegion() {
        return (String)Kernel.get((Object)((Object)this), (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    public void setRegion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"region", (Object)value);
    }

    @Nullable
    public String getSubscriptionRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"subscriptionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setSubscriptionRoleArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"subscriptionRoleArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnSubscription> {
        private final Construct scope;
        private final String id;
        private final CfnSubscriptionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnSubscriptionProps.Builder();
        }

        public Builder protocol(String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder topicArn(String topicArn) {
            this.props.topicArn(topicArn);
            return this;
        }

        public Builder deliveryPolicy(Object deliveryPolicy) {
            this.props.deliveryPolicy(deliveryPolicy);
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder filterPolicy(Object filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        public Builder filterPolicyScope(String filterPolicyScope) {
            this.props.filterPolicyScope(filterPolicyScope);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder rawMessageDelivery(IResolvable rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder redrivePolicy(Object redrivePolicy) {
            this.props.redrivePolicy(redrivePolicy);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder subscriptionRoleArn(String subscriptionRoleArn) {
            this.props.subscriptionRoleArn(subscriptionRoleArn);
            return this;
        }

        public CfnSubscription build() {
            return new CfnSubscription(this.scope, this.id, this.props.build());
        }
    }
}

