/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns.subscriptions;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.ITopicSubscription;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.TopicSubscriptionConfig;
import software.amazon.awscdk.services.sns.subscriptions.;
import software.amazon.awscdk.services.sns.subscriptions.EmailSubscriptionProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sns-subscriptions.EmailSubscription")
public class EmailSubscription
extends JsiiObject
implements ITopicSubscription {
    protected EmailSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EmailSubscription(@NotNull String emailAddress, @Nullable EmailSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(emailAddress, "emailAddress is required"), props});
    }

    public EmailSubscription(@NotNull String emailAddress) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(emailAddress, "emailAddress is required")});
    }

    @NotNull
    public TopicSubscriptionConfig bind(@NotNull ITopic _topic) {
        return (TopicSubscriptionConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(TopicSubscriptionConfig.class), (Object[])new Object[]{Objects.requireNonNull(_topic, "_topic is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EmailSubscription> {
        private final String emailAddress;
        private EmailSubscriptionProps.Builder props;

        public static Builder create(String emailAddress) {
            return new Builder(emailAddress);
        }

        private Builder(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder filterPolicy(Map<String, ? extends SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        public Builder json(Boolean json) {
            this.props().json(json);
            return this;
        }

        public EmailSubscription build() {
            return new EmailSubscription(this.emailAddress, this.props != null ? this.props.build() : null);
        }

        private EmailSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new EmailSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}

