/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ses.;
import software.amazon.awscdk.services.ses.CfnReceiptRule;
import software.amazon.awscdk.services.ses.CfnReceiptRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ses.CfnReceiptRule")
public class CfnReceiptRule
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnReceiptRule.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnReceiptRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReceiptRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnReceiptRule(Construct scope, String id, CfnReceiptRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public Object getRule() {
        return this.jsiiGet("rule", Object.class);
    }

    public void setRule(IResolvable value) {
        this.jsiiSet("rule", Objects.requireNonNull(value, "rule is required"));
    }

    public void setRule(RuleProperty value) {
        this.jsiiSet("rule", Objects.requireNonNull(value, "rule is required"));
    }

    public String getRuleSetName() {
        return (String)this.jsiiGet("ruleSetName", String.class);
    }

    public void setRuleSetName(String value) {
        this.jsiiSet("ruleSetName", Objects.requireNonNull(value, "ruleSetName is required"));
    }

    public String getAfter() {
        return (String)this.jsiiGet("after", String.class);
    }

    public void setAfter(String value) {
        this.jsiiSet("after", value);
    }

    public static interface WorkmailActionProperty
    extends JsiiSerializable {
        public String getOrganizationArn();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String organizationArn;
            private String topicArn;

            public Builder organizationArn(String organizationArn) {
                this.organizationArn = organizationArn;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public WorkmailActionProperty build() {
                return new Jsii.Proxy(this.organizationArn, this.topicArn, null);
            }
        }
    }

    public static interface StopActionProperty
    extends JsiiSerializable {
        public String getScope();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String scope;
            private String topicArn;

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public StopActionProperty build() {
                return new Jsii.Proxy(this.scope, this.topicArn, null);
            }
        }
    }

    public static interface SNSActionProperty
    extends JsiiSerializable {
        public String getEncoding();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String encoding;
            private String topicArn;

            public Builder encoding(String encoding) {
                this.encoding = encoding;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public SNSActionProperty build() {
                return new Jsii.Proxy(this.encoding, this.topicArn, null);
            }
        }
    }

    public static interface S3ActionProperty
    extends JsiiSerializable {
        public String getBucketName();

        public String getKmsKeyArn();

        public String getObjectKeyPrefix();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucketName;
            private String kmsKeyArn;
            private String objectKeyPrefix;
            private String topicArn;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public Builder objectKeyPrefix(String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public S3ActionProperty build() {
                return new Jsii.Proxy(this.bucketName, this.kmsKeyArn, this.objectKeyPrefix, this.topicArn, null);
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public Object getActions();

        public Object getEnabled();

        public String getName();

        public List<String> getRecipients();

        public Object getScanEnabled();

        public String getTlsPolicy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object actions;
            private Object enabled;
            private String name;
            private List<String> recipients;
            private Object scanEnabled;
            private String tlsPolicy;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder recipients(List<String> recipients) {
                this.recipients = recipients;
                return this;
            }

            public Builder scanEnabled(Boolean scanEnabled) {
                this.scanEnabled = scanEnabled;
                return this;
            }

            public Builder scanEnabled(IResolvable scanEnabled) {
                this.scanEnabled = scanEnabled;
                return this;
            }

            public Builder tlsPolicy(String tlsPolicy) {
                this.tlsPolicy = tlsPolicy;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this.actions, this.enabled, this.name, this.recipients, this.scanEnabled, this.tlsPolicy, null);
            }
        }
    }

    public static interface LambdaActionProperty
    extends JsiiSerializable {
        public String getFunctionArn();

        public String getInvocationType();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String functionArn;
            private String invocationType;
            private String topicArn;

            public Builder functionArn(String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            public Builder invocationType(String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public LambdaActionProperty build() {
                return new Jsii.Proxy(this.functionArn, this.invocationType, this.topicArn, null);
            }
        }
    }

    public static interface BounceActionProperty
    extends JsiiSerializable {
        public String getMessage();

        public String getSender();

        public String getSmtpReplyCode();

        public String getStatusCode();

        public String getTopicArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String message;
            private String sender;
            private String smtpReplyCode;
            private String statusCode;
            private String topicArn;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder sender(String sender) {
                this.sender = sender;
                return this;
            }

            public Builder smtpReplyCode(String smtpReplyCode) {
                this.smtpReplyCode = smtpReplyCode;
                return this;
            }

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder topicArn(String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            public BounceActionProperty build() {
                return new Jsii.Proxy(this.message, this.sender, this.smtpReplyCode, this.statusCode, this.topicArn, null);
            }
        }
    }

    public static interface AddHeaderActionProperty
    extends JsiiSerializable {
        public String getHeaderName();

        public String getHeaderValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String headerName;
            private String headerValue;

            public Builder headerName(String headerName) {
                this.headerName = headerName;
                return this;
            }

            public Builder headerValue(String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            public AddHeaderActionProperty build() {
                return new Jsii.Proxy(this.headerName, this.headerValue, null);
            }
        }
    }

    public static interface ActionProperty
    extends JsiiSerializable {
        public Object getAddHeaderAction();

        public Object getBounceAction();

        public Object getLambdaAction();

        public Object getS3Action();

        public Object getSnsAction();

        public Object getStopAction();

        public Object getWorkmailAction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object addHeaderAction;
            private Object bounceAction;
            private Object lambdaAction;
            private Object s3Action;
            private Object snsAction;
            private Object stopAction;
            private Object workmailAction;

            public Builder addHeaderAction(AddHeaderActionProperty addHeaderAction) {
                this.addHeaderAction = addHeaderAction;
                return this;
            }

            public Builder addHeaderAction(IResolvable addHeaderAction) {
                this.addHeaderAction = addHeaderAction;
                return this;
            }

            public Builder bounceAction(BounceActionProperty bounceAction) {
                this.bounceAction = bounceAction;
                return this;
            }

            public Builder bounceAction(IResolvable bounceAction) {
                this.bounceAction = bounceAction;
                return this;
            }

            public Builder lambdaAction(LambdaActionProperty lambdaAction) {
                this.lambdaAction = lambdaAction;
                return this;
            }

            public Builder lambdaAction(IResolvable lambdaAction) {
                this.lambdaAction = lambdaAction;
                return this;
            }

            public Builder s3Action(S3ActionProperty s3Action) {
                this.s3Action = s3Action;
                return this;
            }

            public Builder s3Action(IResolvable s3Action) {
                this.s3Action = s3Action;
                return this;
            }

            public Builder snsAction(SNSActionProperty snsAction) {
                this.snsAction = snsAction;
                return this;
            }

            public Builder snsAction(IResolvable snsAction) {
                this.snsAction = snsAction;
                return this;
            }

            public Builder stopAction(StopActionProperty stopAction) {
                this.stopAction = stopAction;
                return this;
            }

            public Builder stopAction(IResolvable stopAction) {
                this.stopAction = stopAction;
                return this;
            }

            public Builder workmailAction(WorkmailActionProperty workmailAction) {
                this.workmailAction = workmailAction;
                return this;
            }

            public Builder workmailAction(IResolvable workmailAction) {
                this.workmailAction = workmailAction;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this.addHeaderAction, this.bounceAction, this.lambdaAction, this.s3Action, this.snsAction, this.stopAction, this.workmailAction, null);
            }
        }
    }
}

