/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ses.IReceiptRule;
import software.amazon.awscdk.services.ses.IReceiptRuleAction;
import software.amazon.awscdk.services.ses.IReceiptRuleSet;
import software.amazon.awscdk.services.ses.ReceiptRuleProps;
import software.amazon.awscdk.services.ses.TlsPolicy;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface DropSpamReceiptRuleProps
extends JsiiSerializable,
ReceiptRuleProps {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IReceiptRuleSet _ruleSet;
        @Nullable
        private List<IReceiptRuleAction> _actions;
        @Nullable
        private IReceiptRule _after;
        @Nullable
        private Boolean _enabled;
        @Nullable
        private String _name;
        @Nullable
        private List<String> _recipients;
        @Nullable
        private Boolean _scanEnabled;
        @Nullable
        private TlsPolicy _tlsPolicy;

        public Builder withRuleSet(IReceiptRuleSet value) {
            this._ruleSet = Objects.requireNonNull(value, "ruleSet is required");
            return this;
        }

        public Builder withActions(@Nullable List<IReceiptRuleAction> value) {
            this._actions = value;
            return this;
        }

        public Builder withAfter(@Nullable IReceiptRule value) {
            this._after = value;
            return this;
        }

        public Builder withEnabled(@Nullable Boolean value) {
            this._enabled = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withRecipients(@Nullable List<String> value) {
            this._recipients = value;
            return this;
        }

        public Builder withScanEnabled(@Nullable Boolean value) {
            this._scanEnabled = value;
            return this;
        }

        public Builder withTlsPolicy(@Nullable TlsPolicy value) {
            this._tlsPolicy = value;
            return this;
        }

        public DropSpamReceiptRuleProps build() {
            return new DropSpamReceiptRuleProps(){
                private final IReceiptRuleSet $ruleSet;
                @Nullable
                private final List<IReceiptRuleAction> $actions;
                @Nullable
                private final IReceiptRule $after;
                @Nullable
                private final Boolean $enabled;
                @Nullable
                private final String $name;
                @Nullable
                private final List<String> $recipients;
                @Nullable
                private final Boolean $scanEnabled;
                @Nullable
                private final TlsPolicy $tlsPolicy;
                {
                    this.$ruleSet = Objects.requireNonNull(_ruleSet, "ruleSet is required");
                    this.$actions = _actions;
                    this.$after = _after;
                    this.$enabled = _enabled;
                    this.$name = _name;
                    this.$recipients = _recipients;
                    this.$scanEnabled = _scanEnabled;
                    this.$tlsPolicy = _tlsPolicy;
                }

                @Override
                public IReceiptRuleSet getRuleSet() {
                    return this.$ruleSet;
                }

                @Override
                public List<IReceiptRuleAction> getActions() {
                    return this.$actions;
                }

                @Override
                public IReceiptRule getAfter() {
                    return this.$after;
                }

                @Override
                public Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public List<String> getRecipients() {
                    return this.$recipients;
                }

                @Override
                public Boolean getScanEnabled() {
                    return this.$scanEnabled;
                }

                @Override
                public TlsPolicy getTlsPolicy() {
                    return this.$tlsPolicy;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("ruleSet", om.valueToTree((Object)this.getRuleSet()));
                    obj.set("actions", om.valueToTree(this.getActions()));
                    obj.set("after", om.valueToTree((Object)this.getAfter()));
                    obj.set("enabled", om.valueToTree((Object)this.getEnabled()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("recipients", om.valueToTree(this.getRecipients()));
                    obj.set("scanEnabled", om.valueToTree((Object)this.getScanEnabled()));
                    obj.set("tlsPolicy", om.valueToTree((Object)this.getTlsPolicy()));
                    return obj;
                }
            };
        }
    }
}

