/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.JsiiSerializable;

public interface ReceiptRuleS3ActionProps
extends JsiiSerializable {
    public IBucket getBucket();

    public void setBucket(IBucket var1);

    public IEncryptionKey getKmsKey();

    public void setKmsKey(IEncryptionKey var1);

    public String getObjectKeyPrefix();

    public void setObjectKeyPrefix(String var1);

    public ITopic getTopic();

    public void setTopic(ITopic var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        @Nullable
        private IEncryptionKey _kmsKey;
        @Nullable
        private String _objectKeyPrefix;
        @Nullable
        private ITopic _topic;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withKmsKey(@Nullable IEncryptionKey value) {
            this._kmsKey = value;
            return this;
        }

        public Builder withObjectKeyPrefix(@Nullable String value) {
            this._objectKeyPrefix = value;
            return this;
        }

        public Builder withTopic(@Nullable ITopic value) {
            this._topic = value;
            return this;
        }

        public ReceiptRuleS3ActionProps build() {
            return new ReceiptRuleS3ActionProps(){
                private IBucket $bucket;
                @Nullable
                private IEncryptionKey $kmsKey;
                @Nullable
                private String $objectKeyPrefix;
                @Nullable
                private ITopic $topic;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$kmsKey = _kmsKey;
                    this.$objectKeyPrefix = _objectKeyPrefix;
                    this.$topic = _topic;
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(IBucket value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public IEncryptionKey getKmsKey() {
                    return this.$kmsKey;
                }

                @Override
                public void setKmsKey(@Nullable IEncryptionKey value) {
                    this.$kmsKey = value;
                }

                @Override
                public String getObjectKeyPrefix() {
                    return this.$objectKeyPrefix;
                }

                @Override
                public void setObjectKeyPrefix(@Nullable String value) {
                    this.$objectKeyPrefix = value;
                }

                @Override
                public ITopic getTopic() {
                    return this.$topic;
                }

                @Override
                public void setTopic(@Nullable ITopic value) {
                    this.$topic = value;
                }
            };
        }
    }
}

