/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ses.IReceiptRule;
import software.amazon.awscdk.services.ses.IReceiptRuleAction;
import software.amazon.awscdk.services.ses.IReceiptRuleSet;
import software.amazon.awscdk.services.ses.ReceiptRuleOptions;
import software.amazon.awscdk.services.ses.TlsPolicy;
import software.amazon.jsii.JsiiSerializable;

public interface ReceiptRuleProps
extends JsiiSerializable,
ReceiptRuleOptions {
    public IReceiptRuleSet getRuleSet();

    public void setRuleSet(IReceiptRuleSet var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IReceiptRuleSet _ruleSet;
        @Nullable
        private List<IReceiptRuleAction> _actions;
        @Nullable
        private IReceiptRule _after;
        @Nullable
        private Boolean _enabled;
        @Nullable
        private String _name;
        @Nullable
        private List<String> _recipients;
        @Nullable
        private Boolean _scanEnabled;
        @Nullable
        private TlsPolicy _tlsPolicy;

        public Builder withRuleSet(IReceiptRuleSet value) {
            this._ruleSet = Objects.requireNonNull(value, "ruleSet is required");
            return this;
        }

        public Builder withActions(@Nullable List<IReceiptRuleAction> value) {
            this._actions = value;
            return this;
        }

        public Builder withAfter(@Nullable IReceiptRule value) {
            this._after = value;
            return this;
        }

        public Builder withEnabled(@Nullable Boolean value) {
            this._enabled = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withRecipients(@Nullable List<String> value) {
            this._recipients = value;
            return this;
        }

        public Builder withScanEnabled(@Nullable Boolean value) {
            this._scanEnabled = value;
            return this;
        }

        public Builder withTlsPolicy(@Nullable TlsPolicy value) {
            this._tlsPolicy = value;
            return this;
        }

        public ReceiptRuleProps build() {
            return new ReceiptRuleProps(){
                private IReceiptRuleSet $ruleSet;
                @Nullable
                private List<IReceiptRuleAction> $actions;
                @Nullable
                private IReceiptRule $after;
                @Nullable
                private Boolean $enabled;
                @Nullable
                private String $name;
                @Nullable
                private List<String> $recipients;
                @Nullable
                private Boolean $scanEnabled;
                @Nullable
                private TlsPolicy $tlsPolicy;
                {
                    this.$ruleSet = Objects.requireNonNull(_ruleSet, "ruleSet is required");
                    this.$actions = _actions;
                    this.$after = _after;
                    this.$enabled = _enabled;
                    this.$name = _name;
                    this.$recipients = _recipients;
                    this.$scanEnabled = _scanEnabled;
                    this.$tlsPolicy = _tlsPolicy;
                }

                @Override
                public IReceiptRuleSet getRuleSet() {
                    return this.$ruleSet;
                }

                @Override
                public void setRuleSet(IReceiptRuleSet value) {
                    this.$ruleSet = Objects.requireNonNull(value, "ruleSet is required");
                }

                @Override
                public List<IReceiptRuleAction> getActions() {
                    return this.$actions;
                }

                @Override
                public void setActions(@Nullable List<IReceiptRuleAction> value) {
                    this.$actions = value;
                }

                @Override
                public IReceiptRule getAfter() {
                    return this.$after;
                }

                @Override
                public void setAfter(@Nullable IReceiptRule value) {
                    this.$after = value;
                }

                @Override
                public Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public void setEnabled(@Nullable Boolean value) {
                    this.$enabled = value;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public void setName(@Nullable String value) {
                    this.$name = value;
                }

                @Override
                public List<String> getRecipients() {
                    return this.$recipients;
                }

                @Override
                public void setRecipients(@Nullable List<String> value) {
                    this.$recipients = value;
                }

                @Override
                public Boolean getScanEnabled() {
                    return this.$scanEnabled;
                }

                @Override
                public void setScanEnabled(@Nullable Boolean value) {
                    this.$scanEnabled = value;
                }

                @Override
                public TlsPolicy getTlsPolicy() {
                    return this.$tlsPolicy;
                }

                @Override
                public void setTlsPolicy(@Nullable TlsPolicy value) {
                    this.$tlsPolicy = value;
                }
            };
        }
    }
}

