/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicediscovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.servicediscovery.;
import software.amazon.awscdk.services.servicediscovery.CfnService;
import software.amazon.awscdk.services.servicediscovery.CfnServiceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.CfnService")
public class CfnService
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnService.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnService(@NotNull Construct scope, @NotNull String id, @Nullable CfnServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnService(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public Object getDnsConfig() {
        return Kernel.get((Object)((Object)this), (String)"dnsConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDnsConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"dnsConfig", (Object)value);
    }

    public void setDnsConfig(@Nullable DnsConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"dnsConfig", (Object)value);
    }

    @Nullable
    public Object getHealthCheckConfig() {
        return Kernel.get((Object)((Object)this), (String)"healthCheckConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"healthCheckConfig", (Object)value);
    }

    public void setHealthCheckConfig(@Nullable HealthCheckConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"healthCheckConfig", (Object)value);
    }

    @Nullable
    public Object getHealthCheckCustomConfig() {
        return Kernel.get((Object)((Object)this), (String)"healthCheckCustomConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckCustomConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"healthCheckCustomConfig", (Object)value);
    }

    public void setHealthCheckCustomConfig(@Nullable HealthCheckCustomConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"healthCheckCustomConfig", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    @Nullable
    public String getNamespaceId() {
        return (String)Kernel.get((Object)((Object)this), (String)"namespaceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setNamespaceId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"namespaceId", (Object)value);
    }

    @Nullable
    public String getType() {
        return (String)Kernel.get((Object)((Object)this), (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"type", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnService> {
        private final Construct scope;
        private final String id;
        private CfnServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder dnsConfig(IResolvable dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }

        public Builder dnsConfig(DnsConfigProperty dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }

        public Builder healthCheckConfig(IResolvable healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckConfig(HealthCheckConfigProperty healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }

        public Builder healthCheckCustomConfig(IResolvable healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }

        public Builder healthCheckCustomConfig(HealthCheckCustomConfigProperty healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.props().namespaceId(namespaceId);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder type(String type) {
            this.props().type(type);
            return this;
        }

        public CfnService build() {
            return new CfnService(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServiceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.CfnService.HealthCheckCustomConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckCustomConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getFailureThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckCustomConfigProperty> {
            private Number failureThreshold;

            public Builder failureThreshold(Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public HealthCheckCustomConfigProperty build() {
                return new Jsii.Proxy(this.failureThreshold);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.CfnService.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Number getFailureThreshold() {
            return null;
        }

        @Nullable
        default public String getResourcePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            private String type;
            private Number failureThreshold;
            private String resourcePath;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder failureThreshold(Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public Builder resourcePath(String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            public HealthCheckConfigProperty build() {
                return new Jsii.Proxy(this.type, this.failureThreshold, this.resourcePath);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.CfnService.DnsRecordProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsRecordProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTtl();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsRecordProperty> {
            private Number ttl;
            private String type;

            public Builder ttl(Number ttl) {
                this.ttl = ttl;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public DnsRecordProperty build() {
                return new Jsii.Proxy(this.ttl, this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-servicediscovery.CfnService.DnsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DnsConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDnsRecords();

        @Nullable
        default public String getNamespaceId() {
            return null;
        }

        @Nullable
        default public String getRoutingPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DnsConfigProperty> {
            private Object dnsRecords;
            private String namespaceId;
            private String routingPolicy;

            public Builder dnsRecords(IResolvable dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            public Builder dnsRecords(List<? extends Object> dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            public Builder namespaceId(String namespaceId) {
                this.namespaceId = namespaceId;
                return this;
            }

            public Builder routingPolicy(String routingPolicy) {
                this.routingPolicy = routingPolicy;
                return this;
            }

            public DnsConfigProperty build() {
                return new Jsii.Proxy(this.dnsRecords, this.namespaceId, this.routingPolicy);
            }
        }
    }
}

