/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.secretsmanager;

import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.secretsmanager.SecretProps;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.jsii.JsiiSerializable;

public interface SecretProps
extends JsiiSerializable {
    public String getDescription();

    public IKey getEncryptionKey();

    public SecretStringGenerator getGenerateSecretString();

    public String getSecretName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private IKey encryptionKey;
        private SecretStringGenerator generateSecretString;
        private String secretName;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder generateSecretString(SecretStringGenerator generateSecretString) {
            this.generateSecretString = generateSecretString;
            return this;
        }

        public Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public SecretProps build() {
            return new Jsii.Proxy(this.description, this.encryptionKey, this.generateSecretString, this.secretName, null);
        }
    }
}

