/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.secretsmanager;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import software.amazon.awscdk.services.secretsmanager.AttachedSecretOptions;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AttachedSecretProps
extends JsiiSerializable,
AttachedSecretOptions {
    public ISecret getSecret();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ISecret _secret;
        private ISecretAttachmentTarget _target;

        public Builder withSecret(ISecret value) {
            this._secret = Objects.requireNonNull(value, "secret is required");
            return this;
        }

        public Builder withTarget(ISecretAttachmentTarget value) {
            this._target = Objects.requireNonNull(value, "target is required");
            return this;
        }

        public AttachedSecretProps build() {
            return new AttachedSecretProps(){
                private final ISecret $secret;
                private final ISecretAttachmentTarget $target;
                {
                    this.$secret = Objects.requireNonNull(_secret, "secret is required");
                    this.$target = Objects.requireNonNull(_target, "target is required");
                }

                @Override
                public ISecret getSecret() {
                    return this.$secret;
                }

                @Override
                public ISecretAttachmentTarget getTarget() {
                    return this.$target;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("secret", om.valueToTree((Object)this.getSecret()));
                    obj.set("target", om.valueToTree((Object)this.getTarget()));
                    return obj;
                }
            };
        }
    }
}

