/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.$Module;
import software.amazon.awscdk.services.sam.CfnApi;
import software.amazon.awscdk.services.sam.CfnApiProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnApi")
public class CfnApi
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"REQUIRED_TRANSFORM", String.class);

    protected CfnApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApi(@NotNull Construct scope, @NotNull String id, @NotNull CfnApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDefinitionBody() {
        return this.jsiiGet("definitionBody", Object.class);
    }

    public void setDefinitionBody(@NotNull Object value) {
        this.jsiiSet("definitionBody", Objects.requireNonNull(value, "definitionBody is required"));
    }

    @NotNull
    public String getStageName() {
        return (String)this.jsiiGet("stageName", String.class);
    }

    public void setStageName(@NotNull String value) {
        this.jsiiSet("stageName", Objects.requireNonNull(value, "stageName is required"));
    }

    @Nullable
    public Object getAccessLogSetting() {
        return this.jsiiGet("accessLogSetting", Object.class);
    }

    public void setAccessLogSetting(@Nullable IResolvable value) {
        this.jsiiSet("accessLogSetting", value);
    }

    public void setAccessLogSetting(@Nullable AccessLogSettingProperty value) {
        this.jsiiSet("accessLogSetting", value);
    }

    @Nullable
    public Object getAuth() {
        return this.jsiiGet("auth", Object.class);
    }

    public void setAuth(@Nullable IResolvable value) {
        this.jsiiSet("auth", value);
    }

    public void setAuth(@Nullable AuthProperty value) {
        this.jsiiSet("auth", value);
    }

    @Nullable
    public List<String> getBinaryMediaTypes() {
        return Optional.ofNullable((List)this.jsiiGet("binaryMediaTypes", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setBinaryMediaTypes(@Nullable List<String> value) {
        this.jsiiSet("binaryMediaTypes", value);
    }

    @Nullable
    public Object getCacheClusterEnabled() {
        return this.jsiiGet("cacheClusterEnabled", Object.class);
    }

    public void setCacheClusterEnabled(@Nullable Boolean value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    public void setCacheClusterEnabled(@Nullable IResolvable value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    @Nullable
    public String getCacheClusterSize() {
        return (String)this.jsiiGet("cacheClusterSize", String.class);
    }

    public void setCacheClusterSize(@Nullable String value) {
        this.jsiiSet("cacheClusterSize", value);
    }

    @Nullable
    public Object getCors() {
        return this.jsiiGet("cors", Object.class);
    }

    public void setCors(@Nullable String value) {
        this.jsiiSet("cors", value);
    }

    public void setCors(@Nullable IResolvable value) {
        this.jsiiSet("cors", value);
    }

    public void setCors(@Nullable CorsConfigurationProperty value) {
        this.jsiiSet("cors", value);
    }

    @Nullable
    public Object getDefinitionUri() {
        return this.jsiiGet("definitionUri", Object.class);
    }

    public void setDefinitionUri(@Nullable String value) {
        this.jsiiSet("definitionUri", value);
    }

    public void setDefinitionUri(@Nullable IResolvable value) {
        this.jsiiSet("definitionUri", value);
    }

    public void setDefinitionUri(@Nullable S3LocationProperty value) {
        this.jsiiSet("definitionUri", value);
    }

    @Nullable
    public String getEndpointConfiguration() {
        return (String)this.jsiiGet("endpointConfiguration", String.class);
    }

    public void setEndpointConfiguration(@Nullable String value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    @Nullable
    public Object getMethodSettings() {
        return this.jsiiGet("methodSettings", Object.class);
    }

    public void setMethodSettings(@Nullable List<Object> value) {
        this.jsiiSet("methodSettings", value);
    }

    public void setMethodSettings(@Nullable IResolvable value) {
        this.jsiiSet("methodSettings", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public Object getTracingEnabled() {
        return this.jsiiGet("tracingEnabled", Object.class);
    }

    public void setTracingEnabled(@Nullable Boolean value) {
        this.jsiiSet("tracingEnabled", value);
    }

    public void setTracingEnabled(@Nullable IResolvable value) {
        this.jsiiSet("tracingEnabled", value);
    }

    @Nullable
    public Object getVariables() {
        return this.jsiiGet("variables", Object.class);
    }

    public void setVariables(@Nullable IResolvable value) {
        this.jsiiSet("variables", value);
    }

    public void setVariables(@Nullable Map<String, String> value) {
        this.jsiiSet("variables", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApiProps.Builder();
        }

        public Builder stageName(String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        public Builder accessLogSetting(IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder accessLogSetting(AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder auth(IResolvable auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder auth(AuthProperty auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.props.binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        public Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterEnabled(IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterSize(String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        public Builder cors(String cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder cors(IResolvable cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder cors(CorsConfigurationProperty cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder definitionBody(Object definitionBody) {
            this.props.definitionBody(definitionBody);
            return this;
        }

        public Builder definitionUri(String definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(IResolvable definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(S3LocationProperty definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder endpointConfiguration(String endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder methodSettings(List<Object> methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        public Builder methodSettings(IResolvable methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tracingEnabled(Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder tracingEnabled(IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder variables(IResolvable variables) {
            this.props.variables(variables);
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.props.variables(variables);
            return this;
        }

        public CfnApi build() {
            return new CfnApi(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnApi.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        public String getBucket();

        public String getKey();

        public Number getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private String key;
            private Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnApi.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public String getAllowOrigin();

        default public Object getAllowCredentials() {
            return null;
        }

        default public String getAllowHeaders() {
            return null;
        }

        default public String getAllowMethods() {
            return null;
        }

        default public String getMaxAge() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String allowOrigin;
            private Object allowCredentials;
            private String allowHeaders;
            private String allowMethods;
            private String maxAge;

            public Builder allowOrigin(String allowOrigin) {
                this.allowOrigin = allowOrigin;
                return this;
            }

            public Builder allowCredentials(Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            public Builder allowCredentials(IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            public Builder allowHeaders(String allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            public Builder allowMethods(String allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            public Builder maxAge(String maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public CorsConfigurationProperty build() {
                return new Jsii.Proxy(this.allowOrigin, this.allowCredentials, this.allowHeaders, this.allowMethods, this.maxAge, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnApi.AuthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthProperty
    extends JsiiSerializable {
        default public Object getAuthorizers() {
            return null;
        }

        default public String getDefaultAuthorizer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object authorizers;
            private String defaultAuthorizer;

            public Builder authorizers(Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            public Builder defaultAuthorizer(String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            public AuthProperty build() {
                return new Jsii.Proxy(this.authorizers, this.defaultAuthorizer, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sam.CfnApi.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessLogSettingProperty
    extends JsiiSerializable {
        default public String getDestinationArn() {
            return null;
        }

        default public String getFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String destinationArn;
            private String format;

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public AccessLogSettingProperty build() {
                return new Jsii.Proxy(this.destinationArn, this.format, null);
            }
        }
    }
}

