/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sam.;
import software.amazon.awscdk.services.sam.CfnApi;
import software.amazon.awscdk.services.sam.CfnApiProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApi")
public class CfnApi
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);
    public static final String REQUIRED_TRANSFORM = (String)JsiiObject.jsiiStaticGet(CfnApi.class, (String)"REQUIRED_TRANSFORM", String.class);

    protected CfnApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApi(Construct scope, String id, CfnApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public Object getDefinitionBody() {
        return this.jsiiGet("definitionBody", Object.class);
    }

    public void setDefinitionBody(Object value) {
        this.jsiiSet("definitionBody", Objects.requireNonNull(value, "definitionBody is required"));
    }

    public Object getMethodSettings() {
        return this.jsiiGet("methodSettings", Object.class);
    }

    public void setMethodSettings(Object value) {
        this.jsiiSet("methodSettings", Objects.requireNonNull(value, "methodSettings is required"));
    }

    public String getStageName() {
        return (String)this.jsiiGet("stageName", String.class);
    }

    public void setStageName(String value) {
        this.jsiiSet("stageName", Objects.requireNonNull(value, "stageName is required"));
    }

    public Object getAccessLogSetting() {
        return this.jsiiGet("accessLogSetting", Object.class);
    }

    public void setAccessLogSetting(IResolvable value) {
        this.jsiiSet("accessLogSetting", value);
    }

    public void setAccessLogSetting(AccessLogSettingProperty value) {
        this.jsiiSet("accessLogSetting", value);
    }

    public Object getAuth() {
        return this.jsiiGet("auth", Object.class);
    }

    public void setAuth(IResolvable value) {
        this.jsiiSet("auth", value);
    }

    public void setAuth(AuthProperty value) {
        this.jsiiSet("auth", value);
    }

    public List<String> getBinaryMediaTypes() {
        return Collections.unmodifiableList((List)this.jsiiGet("binaryMediaTypes", List.class));
    }

    public void setBinaryMediaTypes(List<String> value) {
        this.jsiiSet("binaryMediaTypes", value);
    }

    public Object getCacheClusterEnabled() {
        return this.jsiiGet("cacheClusterEnabled", Object.class);
    }

    public void setCacheClusterEnabled(Boolean value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    public void setCacheClusterEnabled(IResolvable value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    public String getCacheClusterSize() {
        return (String)this.jsiiGet("cacheClusterSize", String.class);
    }

    public void setCacheClusterSize(String value) {
        this.jsiiSet("cacheClusterSize", value);
    }

    public String getCors() {
        return (String)this.jsiiGet("cors", String.class);
    }

    public void setCors(String value) {
        this.jsiiSet("cors", value);
    }

    public Object getDefinitionUri() {
        return this.jsiiGet("definitionUri", Object.class);
    }

    public void setDefinitionUri(String value) {
        this.jsiiSet("definitionUri", value);
    }

    public void setDefinitionUri(IResolvable value) {
        this.jsiiSet("definitionUri", value);
    }

    public void setDefinitionUri(S3LocationProperty value) {
        this.jsiiSet("definitionUri", value);
    }

    public String getEndpointConfiguration() {
        return (String)this.jsiiGet("endpointConfiguration", String.class);
    }

    public void setEndpointConfiguration(String value) {
        this.jsiiSet("endpointConfiguration", value);
    }

    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(String value) {
        this.jsiiSet("name", value);
    }

    public Object getTracingEnabled() {
        return this.jsiiGet("tracingEnabled", Object.class);
    }

    public void setTracingEnabled(Boolean value) {
        this.jsiiSet("tracingEnabled", value);
    }

    public void setTracingEnabled(IResolvable value) {
        this.jsiiSet("tracingEnabled", value);
    }

    public Object getVariables() {
        return this.jsiiGet("variables", Object.class);
    }

    public void setVariables(IResolvable value) {
        this.jsiiSet("variables", value);
    }

    public void setVariables(Map<String, String> value) {
        this.jsiiSet("variables", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApiProps.Builder();
        }

        public Builder stageName(String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        public Builder accessLogSetting(IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder accessLogSetting(AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        public Builder auth(IResolvable auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder auth(AuthProperty auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.props.binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        public Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterEnabled(IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        public Builder cacheClusterSize(String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        public Builder cors(String cors) {
            this.props.cors(cors);
            return this;
        }

        public Builder definitionBody(Object definitionBody) {
            this.props.definitionBody(definitionBody);
            return this;
        }

        public Builder definitionUri(String definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(IResolvable definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder definitionUri(S3LocationProperty definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        public Builder endpointConfiguration(String endpointConfiguration) {
            this.props.endpointConfiguration(endpointConfiguration);
            return this;
        }

        public Builder methodSettings(Object methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tracingEnabled(Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder tracingEnabled(IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public Builder variables(IResolvable variables) {
            this.props.variables(variables);
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.props.variables(variables);
            return this;
        }

        public CfnApi build() {
            return new CfnApi(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApi.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        public String getBucket();

        public String getKey();

        public Number getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucket;
            private String key;
            private Number version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key, this.version, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApi.AuthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthProperty
    extends JsiiSerializable {
        default public Object getAuthorizers() {
            return null;
        }

        default public String getDefaultAuthorizer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object authorizers;
            private String defaultAuthorizer;

            public Builder authorizers(Object authorizers) {
                this.authorizers = authorizers;
                return this;
            }

            public Builder defaultAuthorizer(String defaultAuthorizer) {
                this.defaultAuthorizer = defaultAuthorizer;
                return this;
            }

            public AuthProperty build() {
                return new Jsii.Proxy(this.authorizers, this.defaultAuthorizer, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-sam.CfnApi.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessLogSettingProperty
    extends JsiiSerializable {
        default public String getDestinationArn() {
            return null;
        }

        default public String getFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String destinationArn;
            private String format;

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public AccessLogSettingProperty build() {
                return new Jsii.Proxy(this.destinationArn, this.format, null);
            }
        }
    }
}

