/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.$Module;
import software.amazon.awscdk.services.sagemaker.CfnModel;
import software.amazon.awscdk.services.sagemaker.CfnModelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModel")
public class CfnModel
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnModel.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnModel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnModel(@NotNull Construct scope, @NotNull String id, @NotNull CfnModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrModelName() {
        return (String)this.jsiiGet("attrModelName", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getExecutionRoleArn() {
        return (String)this.jsiiGet("executionRoleArn", String.class);
    }

    public void setExecutionRoleArn(@NotNull String value) {
        this.jsiiSet("executionRoleArn", Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    @Nullable
    public Object getContainers() {
        return this.jsiiGet("containers", Object.class);
    }

    public void setContainers(@Nullable IResolvable value) {
        this.jsiiSet("containers", value);
    }

    public void setContainers(@Nullable List<Object> value) {
        this.jsiiSet("containers", value);
    }

    @Nullable
    public String getModelName() {
        return (String)this.jsiiGet("modelName", String.class);
    }

    public void setModelName(@Nullable String value) {
        this.jsiiSet("modelName", value);
    }

    @Nullable
    public Object getPrimaryContainer() {
        return this.jsiiGet("primaryContainer", Object.class);
    }

    public void setPrimaryContainer(@Nullable IResolvable value) {
        this.jsiiSet("primaryContainer", value);
    }

    public void setPrimaryContainer(@Nullable ContainerDefinitionProperty value) {
        this.jsiiSet("primaryContainer", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnModel> {
        private final Construct scope;
        private final String id;
        private final CfnModelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnModelProps.Builder();
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder containers(IResolvable containers) {
            this.props.containers(containers);
            return this;
        }

        public Builder containers(List<Object> containers) {
            this.props.containers(containers);
            return this;
        }

        public Builder modelName(String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        public Builder primaryContainer(IResolvable primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        public Builder primaryContainer(ContainerDefinitionProperty primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnModel build() {
            return new CfnModel(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModel.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private List<String> securityGroupIds;
            private List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnets, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-sagemaker.CfnModel.ContainerDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerHostname() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getImage() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        @Nullable
        default public String getModelPackageName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerDefinitionProperty> {
            private String containerHostname;
            private Object environment;
            private String image;
            private String mode;
            private String modelDataUrl;
            private String modelPackageName;

            public Builder containerHostname(String containerHostname) {
                this.containerHostname = containerHostname;
                return this;
            }

            public Builder environment(Object environment) {
                this.environment = environment;
                return this;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public Builder modelPackageName(String modelPackageName) {
                this.modelPackageName = modelPackageName;
                return this;
            }

            public ContainerDefinitionProperty build() {
                return new Jsii.Proxy(this.containerHostname, this.environment, this.image, this.mode, this.modelDataUrl, this.modelPackageName, null);
            }
        }
    }
}

