/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnNotebookInstanceProps
extends JsiiSerializable {
    public String getInstanceType();

    public String getRoleArn();

    public String getDirectInternetAccess();

    public String getKmsKeyId();

    public String getLifecycleConfigName();

    public String getNotebookInstanceName();

    public String getRootAccess();

    public List<String> getSecurityGroupIds();

    public String getSubnetId();

    public List<CfnTag> getTags();

    public Object getVolumeSizeInGb();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _instanceType;
        private String _roleArn;
        @Nullable
        private String _directInternetAccess;
        @Nullable
        private String _kmsKeyId;
        @Nullable
        private String _lifecycleConfigName;
        @Nullable
        private String _notebookInstanceName;
        @Nullable
        private String _rootAccess;
        @Nullable
        private List<String> _securityGroupIds;
        @Nullable
        private String _subnetId;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _volumeSizeInGb;

        public Builder withInstanceType(String value) {
            this._instanceType = Objects.requireNonNull(value, "instanceType is required");
            return this;
        }

        public Builder withRoleArn(String value) {
            this._roleArn = Objects.requireNonNull(value, "roleArn is required");
            return this;
        }

        public Builder withDirectInternetAccess(@Nullable String value) {
            this._directInternetAccess = value;
            return this;
        }

        public Builder withKmsKeyId(@Nullable String value) {
            this._kmsKeyId = value;
            return this;
        }

        public Builder withLifecycleConfigName(@Nullable String value) {
            this._lifecycleConfigName = value;
            return this;
        }

        public Builder withNotebookInstanceName(@Nullable String value) {
            this._notebookInstanceName = value;
            return this;
        }

        public Builder withRootAccess(@Nullable String value) {
            this._rootAccess = value;
            return this;
        }

        public Builder withSecurityGroupIds(@Nullable List<String> value) {
            this._securityGroupIds = value;
            return this;
        }

        public Builder withSubnetId(@Nullable String value) {
            this._subnetId = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withVolumeSizeInGb(@Nullable Number value) {
            this._volumeSizeInGb = value;
            return this;
        }

        public Builder withVolumeSizeInGb(@Nullable Token value) {
            this._volumeSizeInGb = value;
            return this;
        }

        public CfnNotebookInstanceProps build() {
            return new CfnNotebookInstanceProps(){
                private final String $instanceType;
                private final String $roleArn;
                @Nullable
                private final String $directInternetAccess;
                @Nullable
                private final String $kmsKeyId;
                @Nullable
                private final String $lifecycleConfigName;
                @Nullable
                private final String $notebookInstanceName;
                @Nullable
                private final String $rootAccess;
                @Nullable
                private final List<String> $securityGroupIds;
                @Nullable
                private final String $subnetId;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $volumeSizeInGb;
                {
                    this.$instanceType = Objects.requireNonNull(_instanceType, "instanceType is required");
                    this.$roleArn = Objects.requireNonNull(_roleArn, "roleArn is required");
                    this.$directInternetAccess = _directInternetAccess;
                    this.$kmsKeyId = _kmsKeyId;
                    this.$lifecycleConfigName = _lifecycleConfigName;
                    this.$notebookInstanceName = _notebookInstanceName;
                    this.$rootAccess = _rootAccess;
                    this.$securityGroupIds = _securityGroupIds;
                    this.$subnetId = _subnetId;
                    this.$tags = _tags;
                    this.$volumeSizeInGb = _volumeSizeInGb;
                }

                @Override
                public String getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public String getDirectInternetAccess() {
                    return this.$directInternetAccess;
                }

                @Override
                public String getKmsKeyId() {
                    return this.$kmsKeyId;
                }

                @Override
                public String getLifecycleConfigName() {
                    return this.$lifecycleConfigName;
                }

                @Override
                public String getNotebookInstanceName() {
                    return this.$notebookInstanceName;
                }

                @Override
                public String getRootAccess() {
                    return this.$rootAccess;
                }

                @Override
                public List<String> getSecurityGroupIds() {
                    return this.$securityGroupIds;
                }

                @Override
                public String getSubnetId() {
                    return this.$subnetId;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getVolumeSizeInGb() {
                    return this.$volumeSizeInGb;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("instanceType", om.valueToTree((Object)this.getInstanceType()));
                    obj.set("roleArn", om.valueToTree((Object)this.getRoleArn()));
                    if (this.getDirectInternetAccess() != null) {
                        obj.set("directInternetAccess", om.valueToTree((Object)this.getDirectInternetAccess()));
                    }
                    if (this.getKmsKeyId() != null) {
                        obj.set("kmsKeyId", om.valueToTree((Object)this.getKmsKeyId()));
                    }
                    if (this.getLifecycleConfigName() != null) {
                        obj.set("lifecycleConfigName", om.valueToTree((Object)this.getLifecycleConfigName()));
                    }
                    if (this.getNotebookInstanceName() != null) {
                        obj.set("notebookInstanceName", om.valueToTree((Object)this.getNotebookInstanceName()));
                    }
                    if (this.getRootAccess() != null) {
                        obj.set("rootAccess", om.valueToTree((Object)this.getRootAccess()));
                    }
                    if (this.getSecurityGroupIds() != null) {
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                    }
                    if (this.getSubnetId() != null) {
                        obj.set("subnetId", om.valueToTree((Object)this.getSubnetId()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVolumeSizeInGb() != null) {
                        obj.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                    }
                    return obj;
                }
            };
        }
    }
}

