/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnEndpointConfigProps
extends JsiiSerializable {
    public Object getProductionVariants();

    public String getEndpointConfigName();

    public String getKmsKeyId();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _productionVariants;
        @Nullable
        private String _endpointConfigName;
        @Nullable
        private String _kmsKeyId;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withProductionVariants(Token value) {
            this._productionVariants = Objects.requireNonNull(value, "productionVariants is required");
            return this;
        }

        public Builder withProductionVariants(List<Object> value) {
            this._productionVariants = Objects.requireNonNull(value, "productionVariants is required");
            return this;
        }

        public Builder withEndpointConfigName(@Nullable String value) {
            this._endpointConfigName = value;
            return this;
        }

        public Builder withKmsKeyId(@Nullable String value) {
            this._kmsKeyId = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnEndpointConfigProps build() {
            return new CfnEndpointConfigProps(){
                private final Object $productionVariants;
                @Nullable
                private final String $endpointConfigName;
                @Nullable
                private final String $kmsKeyId;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$productionVariants = Objects.requireNonNull(_productionVariants, "productionVariants is required");
                    this.$endpointConfigName = _endpointConfigName;
                    this.$kmsKeyId = _kmsKeyId;
                    this.$tags = _tags;
                }

                @Override
                public Object getProductionVariants() {
                    return this.$productionVariants;
                }

                @Override
                public String getEndpointConfigName() {
                    return this.$endpointConfigName;
                }

                @Override
                public String getKmsKeyId() {
                    return this.$kmsKeyId;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("productionVariants", om.valueToTree(this.getProductionVariants()));
                    if (this.getEndpointConfigName() != null) {
                        obj.set("endpointConfigName", om.valueToTree((Object)this.getEndpointConfigName()));
                    }
                    if (this.getKmsKeyId() != null) {
                        obj.set("kmsKeyId", om.valueToTree((Object)this.getKmsKeyId()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

