/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.$Module;
import software.amazon.awscdk.services.s3.BlockPublicAccess;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.BucketEncryption;
import software.amazon.awscdk.services.s3.BucketMetrics;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.CorsRule;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.Inventory;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.ObjectOwnership;
import software.amazon.awscdk.services.s3.RedirectTarget;
import software.amazon.awscdk.services.s3.RoutingRule;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-s3.BucketProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface BucketProps
extends JsiiSerializable {
    @Nullable
    default public BucketAccessControl getAccessControl() {
        return null;
    }

    @Nullable
    default public Boolean getAutoDeleteObjects() {
        return null;
    }

    @Nullable
    default public BlockPublicAccess getBlockPublicAccess() {
        return null;
    }

    @Nullable
    default public Boolean getBucketKeyEnabled() {
        return null;
    }

    @Nullable
    default public String getBucketName() {
        return null;
    }

    @Nullable
    default public List<CorsRule> getCors() {
        return null;
    }

    @Nullable
    default public BucketEncryption getEncryption() {
        return null;
    }

    @Nullable
    default public IKey getEncryptionKey() {
        return null;
    }

    @Nullable
    default public Boolean getEnforceSsl() {
        return null;
    }

    @Nullable
    default public List<Inventory> getInventories() {
        return null;
    }

    @Nullable
    default public List<LifecycleRule> getLifecycleRules() {
        return null;
    }

    @Nullable
    default public List<BucketMetrics> getMetrics() {
        return null;
    }

    @Nullable
    default public ObjectOwnership getObjectOwnership() {
        return null;
    }

    @Nullable
    default public Boolean getPublicReadAccess() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public IBucket getServerAccessLogsBucket() {
        return null;
    }

    @Nullable
    default public String getServerAccessLogsPrefix() {
        return null;
    }

    @Nullable
    default public Boolean getVersioned() {
        return null;
    }

    @Nullable
    default public String getWebsiteErrorDocument() {
        return null;
    }

    @Nullable
    default public String getWebsiteIndexDocument() {
        return null;
    }

    @Nullable
    default public RedirectTarget getWebsiteRedirect() {
        return null;
    }

    @Nullable
    default public List<RoutingRule> getWebsiteRoutingRules() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BucketProps> {
        private BucketAccessControl accessControl;
        private Boolean autoDeleteObjects;
        private BlockPublicAccess blockPublicAccess;
        private Boolean bucketKeyEnabled;
        private String bucketName;
        private List<CorsRule> cors;
        private BucketEncryption encryption;
        private IKey encryptionKey;
        private Boolean enforceSsl;
        private List<Inventory> inventories;
        private List<LifecycleRule> lifecycleRules;
        private List<BucketMetrics> metrics;
        private ObjectOwnership objectOwnership;
        private Boolean publicReadAccess;
        private RemovalPolicy removalPolicy;
        private IBucket serverAccessLogsBucket;
        private String serverAccessLogsPrefix;
        private Boolean versioned;
        private String websiteErrorDocument;
        private String websiteIndexDocument;
        private RedirectTarget websiteRedirect;
        private List<RoutingRule> websiteRoutingRules;

        public Builder accessControl(BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public Builder autoDeleteObjects(Boolean autoDeleteObjects) {
            this.autoDeleteObjects = autoDeleteObjects;
            return this;
        }

        public Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        public Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder cors(List<? extends CorsRule> cors) {
            this.cors = cors;
            return this;
        }

        public Builder encryption(BucketEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder enforceSsl(Boolean enforceSsl) {
            this.enforceSsl = enforceSsl;
            return this;
        }

        public Builder inventories(List<? extends Inventory> inventories) {
            this.inventories = inventories;
            return this;
        }

        public Builder lifecycleRules(List<? extends LifecycleRule> lifecycleRules) {
            this.lifecycleRules = lifecycleRules;
            return this;
        }

        public Builder metrics(List<? extends BucketMetrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder objectOwnership(ObjectOwnership objectOwnership) {
            this.objectOwnership = objectOwnership;
            return this;
        }

        public Builder publicReadAccess(Boolean publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder serverAccessLogsBucket(IBucket serverAccessLogsBucket) {
            this.serverAccessLogsBucket = serverAccessLogsBucket;
            return this;
        }

        public Builder serverAccessLogsPrefix(String serverAccessLogsPrefix) {
            this.serverAccessLogsPrefix = serverAccessLogsPrefix;
            return this;
        }

        public Builder versioned(Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public Builder websiteErrorDocument(String websiteErrorDocument) {
            this.websiteErrorDocument = websiteErrorDocument;
            return this;
        }

        public Builder websiteIndexDocument(String websiteIndexDocument) {
            this.websiteIndexDocument = websiteIndexDocument;
            return this;
        }

        public Builder websiteRedirect(RedirectTarget websiteRedirect) {
            this.websiteRedirect = websiteRedirect;
            return this;
        }

        public Builder websiteRoutingRules(List<? extends RoutingRule> websiteRoutingRules) {
            this.websiteRoutingRules = websiteRoutingRules;
            return this;
        }

        public BucketProps build() {
            return new Jsii.Proxy(this.accessControl, this.autoDeleteObjects, this.blockPublicAccess, this.bucketKeyEnabled, this.bucketName, this.cors, this.encryption, this.encryptionKey, this.enforceSsl, this.inventories, this.lifecycleRules, this.metrics, this.objectOwnership, this.publicReadAccess, this.removalPolicy, this.serverAccessLogsBucket, this.serverAccessLogsPrefix, this.versioned, this.websiteErrorDocument, this.websiteIndexDocument, this.websiteRedirect, this.websiteRoutingRules);
        }
    }
}

