/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.CfnBucket;
import software.amazon.awscdk.services.s3.CfnBucketProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBucket.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnBucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBucket(@NotNull Construct scope, @NotNull String id, @Nullable CfnBucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnBucket(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDualStackDomainName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrDualStackDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRegionalDomainName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrRegionalDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrWebsiteUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrWebsiteUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public Object getAccelerateConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"accelerateConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAccelerateConfiguration(@Nullable AccelerateConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"accelerateConfiguration", (Object)value);
    }

    public void setAccelerateConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"accelerateConfiguration", (Object)value);
    }

    @Nullable
    public String getAccessControl() {
        return (String)Kernel.get((Object)((Object)this), (String)"accessControl", (NativeType)NativeType.forClass(String.class));
    }

    public void setAccessControl(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"accessControl", (Object)value);
    }

    @Nullable
    public Object getAnalyticsConfigurations() {
        return Kernel.get((Object)((Object)this), (String)"analyticsConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAnalyticsConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"analyticsConfigurations", (Object)value);
    }

    public void setAnalyticsConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"analyticsConfigurations", value);
    }

    @Nullable
    public Object getBucketEncryption() {
        return Kernel.get((Object)((Object)this), (String)"bucketEncryption", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBucketEncryption(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"bucketEncryption", (Object)value);
    }

    public void setBucketEncryption(@Nullable BucketEncryptionProperty value) {
        Kernel.set((Object)((Object)this), (String)"bucketEncryption", (Object)value);
    }

    @Nullable
    public String getBucketName() {
        return (String)Kernel.get((Object)((Object)this), (String)"bucketName", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucketName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"bucketName", (Object)value);
    }

    @Nullable
    public Object getCorsConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"corsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCorsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"corsConfiguration", (Object)value);
    }

    public void setCorsConfiguration(@Nullable CorsConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"corsConfiguration", (Object)value);
    }

    @Nullable
    public Object getIntelligentTieringConfigurations() {
        return Kernel.get((Object)((Object)this), (String)"intelligentTieringConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIntelligentTieringConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"intelligentTieringConfigurations", (Object)value);
    }

    public void setIntelligentTieringConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"intelligentTieringConfigurations", value);
    }

    @Nullable
    public Object getInventoryConfigurations() {
        return Kernel.get((Object)((Object)this), (String)"inventoryConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInventoryConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"inventoryConfigurations", (Object)value);
    }

    public void setInventoryConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"inventoryConfigurations", value);
    }

    @Nullable
    public Object getLifecycleConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"lifecycleConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecycleConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"lifecycleConfiguration", (Object)value);
    }

    public void setLifecycleConfiguration(@Nullable LifecycleConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"lifecycleConfiguration", (Object)value);
    }

    @Nullable
    public Object getLoggingConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"loggingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoggingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"loggingConfiguration", (Object)value);
    }

    public void setLoggingConfiguration(@Nullable LoggingConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"loggingConfiguration", (Object)value);
    }

    @Nullable
    public Object getMetricsConfigurations() {
        return Kernel.get((Object)((Object)this), (String)"metricsConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMetricsConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"metricsConfigurations", (Object)value);
    }

    public void setMetricsConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"metricsConfigurations", value);
    }

    @Nullable
    public Object getNotificationConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"notificationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNotificationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"notificationConfiguration", (Object)value);
    }

    public void setNotificationConfiguration(@Nullable NotificationConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"notificationConfiguration", (Object)value);
    }

    @Nullable
    public Object getObjectLockConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"objectLockConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setObjectLockConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"objectLockConfiguration", (Object)value);
    }

    public void setObjectLockConfiguration(@Nullable ObjectLockConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"objectLockConfiguration", (Object)value);
    }

    @Nullable
    public Object getObjectLockEnabled() {
        return Kernel.get((Object)((Object)this), (String)"objectLockEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setObjectLockEnabled(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"objectLockEnabled", (Object)value);
    }

    public void setObjectLockEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"objectLockEnabled", (Object)value);
    }

    @Nullable
    public Object getOwnershipControls() {
        return Kernel.get((Object)((Object)this), (String)"ownershipControls", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOwnershipControls(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"ownershipControls", (Object)value);
    }

    public void setOwnershipControls(@Nullable OwnershipControlsProperty value) {
        Kernel.set((Object)((Object)this), (String)"ownershipControls", (Object)value);
    }

    @Nullable
    public Object getPublicAccessBlockConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"publicAccessBlockConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPublicAccessBlockConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"publicAccessBlockConfiguration", (Object)value);
    }

    public void setPublicAccessBlockConfiguration(@Nullable PublicAccessBlockConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"publicAccessBlockConfiguration", (Object)value);
    }

    @Nullable
    public Object getReplicationConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"replicationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReplicationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"replicationConfiguration", (Object)value);
    }

    public void setReplicationConfiguration(@Nullable ReplicationConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"replicationConfiguration", (Object)value);
    }

    @Nullable
    public Object getVersioningConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"versioningConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVersioningConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"versioningConfiguration", (Object)value);
    }

    public void setVersioningConfiguration(@Nullable VersioningConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"versioningConfiguration", (Object)value);
    }

    @Nullable
    public Object getWebsiteConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"websiteConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWebsiteConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"websiteConfiguration", (Object)value);
    }

    public void setWebsiteConfiguration(@Nullable WebsiteConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"websiteConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnBucket> {
        private final Construct scope;
        private final String id;
        private CfnBucketProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accelerateConfiguration(AccelerateConfigurationProperty accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        public Builder accelerateConfiguration(IResolvable accelerateConfiguration) {
            this.props().accelerateConfiguration(accelerateConfiguration);
            return this;
        }

        public Builder accessControl(String accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        public Builder analyticsConfigurations(IResolvable analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        public Builder analyticsConfigurations(List<? extends Object> analyticsConfigurations) {
            this.props().analyticsConfigurations(analyticsConfigurations);
            return this;
        }

        public Builder bucketEncryption(IResolvable bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        public Builder bucketEncryption(BucketEncryptionProperty bucketEncryption) {
            this.props().bucketEncryption(bucketEncryption);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        public Builder corsConfiguration(IResolvable corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        public Builder corsConfiguration(CorsConfigurationProperty corsConfiguration) {
            this.props().corsConfiguration(corsConfiguration);
            return this;
        }

        public Builder intelligentTieringConfigurations(IResolvable intelligentTieringConfigurations) {
            this.props().intelligentTieringConfigurations(intelligentTieringConfigurations);
            return this;
        }

        public Builder intelligentTieringConfigurations(List<? extends Object> intelligentTieringConfigurations) {
            this.props().intelligentTieringConfigurations(intelligentTieringConfigurations);
            return this;
        }

        public Builder inventoryConfigurations(IResolvable inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        public Builder inventoryConfigurations(List<? extends Object> inventoryConfigurations) {
            this.props().inventoryConfigurations(inventoryConfigurations);
            return this;
        }

        public Builder lifecycleConfiguration(IResolvable lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder lifecycleConfiguration(LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props().lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        public Builder loggingConfiguration(IResolvable loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder loggingConfiguration(LoggingConfigurationProperty loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder metricsConfigurations(IResolvable metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        public Builder metricsConfigurations(List<? extends Object> metricsConfigurations) {
            this.props().metricsConfigurations(metricsConfigurations);
            return this;
        }

        public Builder notificationConfiguration(IResolvable notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        public Builder notificationConfiguration(NotificationConfigurationProperty notificationConfiguration) {
            this.props().notificationConfiguration(notificationConfiguration);
            return this;
        }

        public Builder objectLockConfiguration(IResolvable objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        public Builder objectLockConfiguration(ObjectLockConfigurationProperty objectLockConfiguration) {
            this.props().objectLockConfiguration(objectLockConfiguration);
            return this;
        }

        public Builder objectLockEnabled(Boolean objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        public Builder objectLockEnabled(IResolvable objectLockEnabled) {
            this.props().objectLockEnabled(objectLockEnabled);
            return this;
        }

        public Builder ownershipControls(IResolvable ownershipControls) {
            this.props().ownershipControls(ownershipControls);
            return this;
        }

        public Builder ownershipControls(OwnershipControlsProperty ownershipControls) {
            this.props().ownershipControls(ownershipControls);
            return this;
        }

        public Builder publicAccessBlockConfiguration(IResolvable publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props().publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder replicationConfiguration(IResolvable replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder replicationConfiguration(ReplicationConfigurationProperty replicationConfiguration) {
            this.props().replicationConfiguration(replicationConfiguration);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder versioningConfiguration(IResolvable versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        public Builder versioningConfiguration(VersioningConfigurationProperty versioningConfiguration) {
            this.props().versioningConfiguration(versioningConfiguration);
            return this;
        }

        public Builder websiteConfiguration(IResolvable websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        public Builder websiteConfiguration(WebsiteConfigurationProperty websiteConfiguration) {
            this.props().websiteConfiguration(websiteConfiguration);
            return this;
        }

        public CfnBucket build() {
            return new CfnBucket(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnBucketProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnBucketProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.WebsiteConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getErrorDocument() {
            return null;
        }

        @Nullable
        default public String getIndexDocument() {
            return null;
        }

        @Nullable
        default public Object getRedirectAllRequestsTo() {
            return null;
        }

        @Nullable
        default public Object getRoutingRules() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebsiteConfigurationProperty> {
            String errorDocument;
            String indexDocument;
            Object redirectAllRequestsTo;
            Object routingRules;

            public Builder errorDocument(String errorDocument) {
                this.errorDocument = errorDocument;
                return this;
            }

            public Builder indexDocument(String indexDocument) {
                this.indexDocument = indexDocument;
                return this;
            }

            public Builder redirectAllRequestsTo(IResolvable redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder redirectAllRequestsTo(RedirectAllRequestsToProperty redirectAllRequestsTo) {
                this.redirectAllRequestsTo = redirectAllRequestsTo;
                return this;
            }

            public Builder routingRules(IResolvable routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public Builder routingRules(List<? extends Object> routingRules) {
                this.routingRules = routingRules;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.VersioningConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VersioningConfigurationProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getStorageClass();

        @Nullable
        default public Object getTransitionDate() {
            return null;
        }

        @Nullable
        default public Number getTransitionInDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransitionProperty> {
            String storageClass;
            Object transitionDate;
            Number transitionInDays;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionDate(IResolvable transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionDate(Instant transitionDate) {
                this.transitionDate = transitionDate;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public TransitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TopicConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getTopic();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopicConfigurationProperty> {
            String event;
            String topic;
            Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TieringProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TieringProperty
    extends JsiiSerializable {
        @NotNull
        public String getAccessTier();

        @NotNull
        public Number getDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TieringProperty> {
            String accessTier;
            Number days;

            public Builder accessTier(String accessTier) {
                this.accessTier = accessTier;
                return this;
            }

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public TieringProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFilterProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.StorageClassAnalysisProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataExport() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageClassAnalysisProperty> {
            Object dataExport;

            public Builder dataExport(IResolvable dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public Builder dataExport(DataExportProperty dataExport) {
                this.dataExport = dataExport;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.SseKmsEncryptedObjectsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SseKmsEncryptedObjectsProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.SourceSelectionCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getReplicaModifications() {
            return null;
        }

        @Nullable
        default public Object getSseKmsEncryptedObjects() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceSelectionCriteriaProperty> {
            Object replicaModifications;
            Object sseKmsEncryptedObjects;

            public Builder replicaModifications(IResolvable replicaModifications) {
                this.replicaModifications = replicaModifications;
                return this;
            }

            public Builder replicaModifications(ReplicaModificationsProperty replicaModifications) {
                this.replicaModifications = replicaModifications;
                return this;
            }

            public Builder sseKmsEncryptedObjects(IResolvable sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public Builder sseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty sseKmsEncryptedObjects) {
                this.sseKmsEncryptedObjects = sseKmsEncryptedObjects;
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBucketKeyEnabled() {
            return null;
        }

        @Nullable
        default public Object getServerSideEncryptionByDefault() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServerSideEncryptionRuleProperty> {
            Object bucketKeyEnabled;
            Object serverSideEncryptionByDefault;

            public Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            public Builder bucketKeyEnabled(IResolvable bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            public Builder serverSideEncryptionByDefault(IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public Builder serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ServerSideEncryptionByDefaultProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        @NotNull
        public String getSseAlgorithm();

        @Nullable
        default public String getKmsMasterKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServerSideEncryptionByDefaultProperty> {
            String sseAlgorithm;
            String kmsMasterKeyId;

            public Builder sseAlgorithm(String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            public Builder kmsMasterKeyId(String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public S3KeyFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        @Nullable
        default public Object getExpirationDate() {
            return null;
        }

        @Nullable
        default public Number getExpirationInDays() {
            return null;
        }

        @Nullable
        default public Object getExpiredObjectDeleteMarker() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Object getNoncurrentVersionExpiration() {
            return null;
        }

        @Nullable
        default public Number getNoncurrentVersionExpirationInDays() {
            return null;
        }

        @Nullable
        default public Object getNoncurrentVersionTransition() {
            return null;
        }

        @Nullable
        default public Object getNoncurrentVersionTransitions() {
            return null;
        }

        @Nullable
        default public Number getObjectSizeGreaterThan() {
            return null;
        }

        @Nullable
        default public Number getObjectSizeLessThan() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        @Nullable
        default public Object getTransition() {
            return null;
        }

        @Nullable
        default public Object getTransitions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuleProperty> {
            String status;
            Object abortIncompleteMultipartUpload;
            Object expirationDate;
            Number expirationInDays;
            Object expiredObjectDeleteMarker;
            String id;
            Object noncurrentVersionExpiration;
            Number noncurrentVersionExpirationInDays;
            Object noncurrentVersionTransition;
            Object noncurrentVersionTransitions;
            Number objectSizeGreaterThan;
            Number objectSizeLessThan;
            String prefix;
            Object tagFilters;
            Object transition;
            Object transitions;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            public Builder expirationDate(IResolvable expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationDate(Instant expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            public Builder expirationInDays(Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            public Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
                this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
                return this;
            }

            public Builder expiredObjectDeleteMarker(IResolvable expiredObjectDeleteMarker) {
                this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder noncurrentVersionExpiration(IResolvable noncurrentVersionExpiration) {
                this.noncurrentVersionExpiration = noncurrentVersionExpiration;
                return this;
            }

            public Builder noncurrentVersionExpiration(NoncurrentVersionExpirationProperty noncurrentVersionExpiration) {
                this.noncurrentVersionExpiration = noncurrentVersionExpiration;
                return this;
            }

            public Builder noncurrentVersionExpirationInDays(Number noncurrentVersionExpirationInDays) {
                this.noncurrentVersionExpirationInDays = noncurrentVersionExpirationInDays;
                return this;
            }

            public Builder noncurrentVersionTransition(IResolvable noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransition(NoncurrentVersionTransitionProperty noncurrentVersionTransition) {
                this.noncurrentVersionTransition = noncurrentVersionTransition;
                return this;
            }

            public Builder noncurrentVersionTransitions(IResolvable noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder noncurrentVersionTransitions(List<? extends Object> noncurrentVersionTransitions) {
                this.noncurrentVersionTransitions = noncurrentVersionTransitions;
                return this;
            }

            public Builder objectSizeGreaterThan(Number objectSizeGreaterThan) {
                this.objectSizeGreaterThan = objectSizeGreaterThan;
                return this;
            }

            public Builder objectSizeLessThan(Number objectSizeLessThan) {
                this.objectSizeLessThan = objectSizeLessThan;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder transition(IResolvable transition) {
                this.transition = transition;
                return this;
            }

            public Builder transition(TransitionProperty transition) {
                this.transition = transition;
                return this;
            }

            public Builder transitions(IResolvable transitions) {
                this.transitions = transitions;
                return this;
            }

            public Builder transitions(List<? extends Object> transitions) {
                this.transitions = transitions;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RoutingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRedirectRule();

        @Nullable
        default public Object getRoutingRuleCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RoutingRuleProperty> {
            Object redirectRule;
            Object routingRuleCondition;

            public Builder redirectRule(IResolvable redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder redirectRule(RedirectRuleProperty redirectRule) {
                this.redirectRule = redirectRule;
                return this;
            }

            public Builder routingRuleCondition(IResolvable routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public Builder routingRuleCondition(RoutingRuleConditionProperty routingRuleCondition) {
                this.routingRuleCondition = routingRuleCondition;
                return this;
            }

            public RoutingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RoutingRuleConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHttpErrorCodeReturnedEquals() {
            return null;
        }

        @Nullable
        default public String getKeyPrefixEquals() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RoutingRuleConditionProperty> {
            String httpErrorCodeReturnedEquals;
            String keyPrefixEquals;

            public Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
                this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
                return this;
            }

            public Builder keyPrefixEquals(String keyPrefixEquals) {
                this.keyPrefixEquals = keyPrefixEquals;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationTimeValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationTimeValueProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMinutes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationTimeValueProperty> {
            Number minutes;

            public Builder minutes(Number minutes) {
                this.minutes = minutes;
                return this;
            }

            public ReplicationTimeValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationTimeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationTimeProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @NotNull
        public Object getTime();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationTimeProperty> {
            String status;
            Object time;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder time(IResolvable time) {
                this.time = time;
                return this;
            }

            public Builder time(ReplicationTimeValueProperty time) {
                this.time = time;
                return this;
            }

            public ReplicationTimeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public String getStatus();

        @Nullable
        default public Object getDeleteMarkerReplication() {
            return null;
        }

        @Nullable
        default public Object getFilter() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Number getPriority() {
            return null;
        }

        @Nullable
        default public Object getSourceSelectionCriteria() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationRuleProperty> {
            Object destination;
            String status;
            Object deleteMarkerReplication;
            Object filter;
            String id;
            String prefix;
            Number priority;
            Object sourceSelectionCriteria;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(ReplicationDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder deleteMarkerReplication(IResolvable deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            public Builder deleteMarkerReplication(DeleteMarkerReplicationProperty deleteMarkerReplication) {
                this.deleteMarkerReplication = deleteMarkerReplication;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(ReplicationRuleFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder sourceSelectionCriteria(IResolvable sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public Builder sourceSelectionCriteria(SourceSelectionCriteriaProperty sourceSelectionCriteria) {
                this.sourceSelectionCriteria = sourceSelectionCriteria;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationRuleFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationRuleFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAnd() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationRuleFilterProperty> {
            Object and;
            String prefix;
            Object tagFilter;

            public Builder and(IResolvable and) {
                this.and = and;
                return this;
            }

            public Builder and(ReplicationRuleAndOperatorProperty and) {
                this.and = and;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilter(IResolvable tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            public Builder tagFilter(TagFilterProperty tagFilter) {
                this.tagFilter = tagFilter;
                return this;
            }

            public ReplicationRuleFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationRuleAndOperatorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationRuleAndOperatorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationRuleAndOperatorProperty> {
            String prefix;
            Object tagFilters;

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public ReplicationRuleAndOperatorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public Object getAccessControlTranslation() {
            return null;
        }

        @Nullable
        default public String getAccount() {
            return null;
        }

        @Nullable
        default public Object getEncryptionConfiguration() {
            return null;
        }

        @Nullable
        default public Object getMetrics() {
            return null;
        }

        @Nullable
        default public Object getReplicationTime() {
            return null;
        }

        @Nullable
        default public String getStorageClass() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationDestinationProperty> {
            String bucket;
            Object accessControlTranslation;
            String account;
            Object encryptionConfiguration;
            Object metrics;
            Object replicationTime;
            String storageClass;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder accessControlTranslation(IResolvable accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder accessControlTranslation(AccessControlTranslationProperty accessControlTranslation) {
                this.accessControlTranslation = accessControlTranslation;
                return this;
            }

            public Builder account(String account) {
                this.account = account;
                return this;
            }

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder metrics(IResolvable metrics) {
                this.metrics = metrics;
                return this;
            }

            public Builder metrics(MetricsProperty metrics) {
                this.metrics = metrics;
                return this;
            }

            public Builder replicationTime(IResolvable replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            public Builder replicationTime(ReplicationTimeProperty replicationTime) {
                this.replicationTime = replicationTime;
                return this;
            }

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRole();

        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicationConfigurationProperty> {
            String role;
            Object rules;

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ReplicaModificationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicaModificationsProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicaModificationsProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public ReplicaModificationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RedirectRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHostName() {
            return null;
        }

        @Nullable
        default public String getHttpRedirectCode() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public String getReplaceKeyPrefixWith() {
            return null;
        }

        @Nullable
        default public String getReplaceKeyWith() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedirectRuleProperty> {
            String hostName;
            String httpRedirectCode;
            String protocol;
            String replaceKeyPrefixWith;
            String replaceKeyWith;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder httpRedirectCode(String httpRedirectCode) {
                this.httpRedirectCode = httpRedirectCode;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
                this.replaceKeyPrefixWith = replaceKeyPrefixWith;
                return this;
            }

            public Builder replaceKeyWith(String replaceKeyWith) {
                this.replaceKeyWith = replaceKeyWith;
                return this;
            }

            public RedirectRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.RedirectAllRequestsToProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        @NotNull
        public String getHostName();

        @Nullable
        default public String getProtocol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedirectAllRequestsToProperty> {
            String hostName;
            String protocol;

            public Builder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.QueueConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getQueue();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QueueConfigurationProperty> {
            String event;
            String queue;
            Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlockPublicAcls() {
            return null;
        }

        @Nullable
        default public Object getBlockPublicPolicy() {
            return null;
        }

        @Nullable
        default public Object getIgnorePublicAcls() {
            return null;
        }

        @Nullable
        default public Object getRestrictPublicBuckets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            Object blockPublicAcls;
            Object blockPublicPolicy;
            Object ignorePublicAcls;
            Object restrictPublicBuckets;

            public Builder blockPublicAcls(Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicAcls(IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder blockPublicPolicy(IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder ignorePublicAcls(IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public Builder restrictPublicBuckets(IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.OwnershipControlsRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OwnershipControlsRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getObjectOwnership() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OwnershipControlsRuleProperty> {
            String objectOwnership;

            public Builder objectOwnership(String objectOwnership) {
                this.objectOwnership = objectOwnership;
                return this;
            }

            public OwnershipControlsRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.OwnershipControlsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OwnershipControlsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OwnershipControlsProperty> {
            Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public OwnershipControlsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ObjectLockRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObjectLockRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultRetention() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ObjectLockRuleProperty> {
            Object defaultRetention;

            public Builder defaultRetention(IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public Builder defaultRetention(DefaultRetentionProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            public ObjectLockRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.ObjectLockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ObjectLockConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getObjectLockEnabled() {
            return null;
        }

        @Nullable
        default public Object getRule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ObjectLockConfigurationProperty> {
            String objectLockEnabled;
            Object rule;

            public Builder objectLockEnabled(String objectLockEnabled) {
                this.objectLockEnabled = objectLockEnabled;
                return this;
            }

            public Builder rule(IResolvable rule) {
                this.rule = rule;
                return this;
            }

            public Builder rule(ObjectLockRuleProperty rule) {
                this.rule = rule;
                return this;
            }

            public ObjectLockConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NotificationFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Key();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationFilterProperty> {
            Object s3Key;

            public Builder s3Key(IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3Key(S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public NotificationFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEventBridgeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getLambdaConfigurations() {
            return null;
        }

        @Nullable
        default public Object getQueueConfigurations() {
            return null;
        }

        @Nullable
        default public Object getTopicConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            Object eventBridgeConfiguration;
            Object lambdaConfigurations;
            Object queueConfigurations;
            Object topicConfigurations;

            public Builder eventBridgeConfiguration(IResolvable eventBridgeConfiguration) {
                this.eventBridgeConfiguration = eventBridgeConfiguration;
                return this;
            }

            public Builder eventBridgeConfiguration(EventBridgeConfigurationProperty eventBridgeConfiguration) {
                this.eventBridgeConfiguration = eventBridgeConfiguration;
                return this;
            }

            public Builder lambdaConfigurations(IResolvable lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder lambdaConfigurations(List<? extends Object> lambdaConfigurations) {
                this.lambdaConfigurations = lambdaConfigurations;
                return this;
            }

            public Builder queueConfigurations(IResolvable queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder queueConfigurations(List<? extends Object> queueConfigurations) {
                this.queueConfigurations = queueConfigurations;
                return this;
            }

            public Builder topicConfigurations(IResolvable topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public Builder topicConfigurations(List<? extends Object> topicConfigurations) {
                this.topicConfigurations = topicConfigurations;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionTransitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getStorageClass();

        @NotNull
        public Number getTransitionInDays();

        @Nullable
        default public Number getNewerNoncurrentVersions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NoncurrentVersionTransitionProperty> {
            String storageClass;
            Number transitionInDays;
            Number newerNoncurrentVersions;

            public Builder storageClass(String storageClass) {
                this.storageClass = storageClass;
                return this;
            }

            public Builder transitionInDays(Number transitionInDays) {
                this.transitionInDays = transitionInDays;
                return this;
            }

            public Builder newerNoncurrentVersions(Number newerNoncurrentVersions) {
                this.newerNoncurrentVersions = newerNoncurrentVersions;
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.NoncurrentVersionExpirationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NoncurrentVersionExpirationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getNoncurrentDays();

        @Nullable
        default public Number getNewerNoncurrentVersions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NoncurrentVersionExpirationProperty> {
            Number noncurrentDays;
            Number newerNoncurrentVersions;

            public Builder noncurrentDays(Number noncurrentDays) {
                this.noncurrentDays = noncurrentDays;
                return this;
            }

            public Builder newerNoncurrentVersions(Number newerNoncurrentVersions) {
                this.newerNoncurrentVersions = newerNoncurrentVersions;
                return this;
            }

            public NoncurrentVersionExpirationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.MetricsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public Object getEventThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricsProperty> {
            String status;
            Object eventThreshold;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder eventThreshold(IResolvable eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            public Builder eventThreshold(ReplicationTimeValueProperty eventThreshold) {
                this.eventThreshold = eventThreshold;
                return this;
            }

            public MetricsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.MetricsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @Nullable
        default public String getAccessPointArn() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricsConfigurationProperty> {
            String id;
            String accessPointArn;
            String prefix;
            Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder accessPointArn(String accessPointArn) {
                this.accessPointArn = accessPointArn;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationBucketName() {
            return null;
        }

        @Nullable
        default public String getLogFilePrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            String destinationBucketName;
            String logFilePrefix;

            public Builder destinationBucketName(String destinationBucketName) {
                this.destinationBucketName = destinationBucketName;
                return this;
            }

            public Builder logFilePrefix(String logFilePrefix) {
                this.logFilePrefix = logFilePrefix;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            Object rules;

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.LambdaConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEvent();

        @NotNull
        public String getFunction();

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaConfigurationProperty> {
            String event;
            String function;
            Object filter;

            public Builder event(String event) {
                this.event = event;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.InventoryConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public Object getEnabled();

        @NotNull
        public String getId();

        @NotNull
        public String getIncludedObjectVersions();

        @NotNull
        public String getScheduleFrequency();

        @Nullable
        default public List<String> getOptionalFields() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InventoryConfigurationProperty> {
            Object destination;
            Object enabled;
            String id;
            String includedObjectVersions;
            String scheduleFrequency;
            List<String> optionalFields;
            String prefix;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder includedObjectVersions(String includedObjectVersions) {
                this.includedObjectVersions = includedObjectVersions;
                return this;
            }

            public Builder scheduleFrequency(String scheduleFrequency) {
                this.scheduleFrequency = scheduleFrequency;
                return this;
            }

            public Builder optionalFields(List<String> optionalFields) {
                this.optionalFields = optionalFields;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.IntelligentTieringConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntelligentTieringConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public String getStatus();

        @NotNull
        public Object getTierings();

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntelligentTieringConfigurationProperty> {
            String id;
            String status;
            Object tierings;
            String prefix;
            Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder tierings(IResolvable tierings) {
                this.tierings = tierings;
                return this;
            }

            public Builder tierings(List<? extends Object> tierings) {
                this.tierings = tierings;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public IntelligentTieringConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.FilterRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterRuleProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public FilterRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.EventBridgeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventBridgeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEventBridgeEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventBridgeConfigurationProperty> {
            Object eventBridgeEnabled;

            public Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
                this.eventBridgeEnabled = eventBridgeEnabled;
                return this;
            }

            public Builder eventBridgeEnabled(IResolvable eventBridgeEnabled) {
                this.eventBridgeEnabled = eventBridgeEnabled;
                return this;
            }

            public EventBridgeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getReplicaKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            String replicaKmsKeyId;

            public Builder replicaKmsKeyId(String replicaKmsKeyId) {
                this.replicaKmsKeyId = replicaKmsKeyId;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFormat();

        @Nullable
        default public String getBucketAccountId() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationProperty> {
            String bucketArn;
            String format;
            String bucketAccountId;
            String prefix;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder bucketAccountId(String bucketAccountId) {
                this.bucketAccountId = bucketAccountId;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public DestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DeleteMarkerReplicationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeleteMarkerReplicationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeleteMarkerReplicationProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public DeleteMarkerReplicationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DefaultRetentionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultRetentionProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDays() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public Number getYears() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultRetentionProperty> {
            Number days;
            String mode;
            Number years;

            public Builder days(Number days) {
                this.days = days;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder years(Number years) {
                this.years = years;
                return this;
            }

            public DefaultRetentionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.DataExportProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataExportProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDestination();

        @NotNull
        public String getOutputSchemaVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataExportProperty> {
            Object destination;
            String outputSchemaVersion;

            public Builder destination(IResolvable destination) {
                this.destination = destination;
                return this;
            }

            public Builder destination(DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            public Builder outputSchemaVersion(String outputSchemaVersion) {
                this.outputSchemaVersion = outputSchemaVersion;
                return this;
            }

            public DataExportProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.CorsRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsRuleProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getAllowedMethods();

        @NotNull
        public List<String> getAllowedOrigins();

        @Nullable
        default public List<String> getAllowedHeaders() {
            return null;
        }

        @Nullable
        default public List<String> getExposedHeaders() {
            return null;
        }

        @Nullable
        default public String getId() {
            return null;
        }

        @Nullable
        default public Number getMaxAge() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CorsRuleProperty> {
            List<String> allowedMethods;
            List<String> allowedOrigins;
            List<String> allowedHeaders;
            List<String> exposedHeaders;
            String id;
            Number maxAge;

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder allowedOrigins(List<String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            public Builder allowedHeaders(List<String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            public Builder exposedHeaders(List<String> exposedHeaders) {
                this.exposedHeaders = exposedHeaders;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder maxAge(Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public CorsRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCorsRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CorsConfigurationProperty> {
            Object corsRules;

            public Builder corsRules(IResolvable corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public Builder corsRules(List<? extends Object> corsRules) {
                this.corsRules = corsRules;
                return this;
            }

            public CorsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.BucketEncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServerSideEncryptionConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BucketEncryptionProperty> {
            Object serverSideEncryptionConfiguration;

            public Builder serverSideEncryptionConfiguration(IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public Builder serverSideEncryptionConfiguration(List<? extends Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            public BucketEncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public Object getStorageClassAnalysis();

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            String id;
            Object storageClassAnalysis;
            String prefix;
            Object tagFilters;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder storageClassAnalysis(IResolvable storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder storageClassAnalysis(StorageClassAnalysisProperty storageClassAnalysis) {
                this.storageClassAnalysis = storageClassAnalysis;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<? extends Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AccessControlTranslationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwner();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessControlTranslationProperty> {
            String owner;

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AccelerateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAccelerationStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccelerateConfigurationProperty> {
            String accelerationStatus;

            public Builder accelerationStatus(String accelerationStatus) {
                this.accelerationStatus = accelerationStatus;
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        @NotNull
        public Number getDaysAfterInitiation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AbortIncompleteMultipartUploadProperty> {
            Number daysAfterInitiation;

            public Builder daysAfterInitiation(Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

