/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.events.EventRule;
import software.amazon.awscdk.services.events.IEventRuleTarget;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.BucketImportProps;
import software.amazon.awscdk.services.s3.BucketPolicy;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.LifecycleRule;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.Bucket")
public class Bucket
extends Resource {
    protected Bucket(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public Bucket(Construct scope, String id, @Nullable BucketProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Bucket(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static IBucket import_(Construct scope, String id, BucketImportProps props) {
        return (IBucket)JsiiObject.jsiiStaticCall(Bucket.class, (String)"import", IBucket.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addLifecycleRule(LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public void addToResourcePolicy(PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[]{Objects.requireNonNull(permission, "permission is required")});
    }

    public String arnForObjects(String ... keyPattern) {
        return (String)this.jsiiCall("arnForObjects", String.class, Arrays.stream(keyPattern).toArray(Object[]::new));
    }

    public BucketImportProps export() {
        return (BucketImportProps)this.jsiiCall("export", BucketImportProps.class, new Object[0]);
    }

    public Grant grantDelete(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    public Grant grantDelete(IGrantable identity) {
        return (Grant)this.jsiiCall("grantDelete", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    public Grant grantPublicAccess(@Nullable String keyPrefix, String ... allowedActions) {
        return (Grant)this.jsiiCall("grantPublicAccess", Grant.class, Stream.concat(Arrays.stream(new Object[]{keyPrefix}), Arrays.stream(allowedActions)).toArray(Object[]::new));
    }

    public Grant grantPut(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    public Grant grantPut(IGrantable identity) {
        return (Grant)this.jsiiCall("grantPut", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    public Grant grantRead(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    public Grant grantRead(IGrantable identity) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    public Grant grantReadWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    public Grant grantReadWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    public Grant grantWrite(IGrantable identity, @Nullable Object objectsKeyPattern) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern});
    }

    public Grant grantWrite(IGrantable identity) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    public void onEvent(EventType event, IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("onEvent", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(event, "event is required"), Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void onObjectCreated(IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("onObjectCreated", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public void onObjectRemoved(IBucketNotificationDestination dest, NotificationKeyFilter ... filters) {
        this.jsiiCall("onObjectRemoved", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(dest, "dest is required")}), Arrays.stream(filters)).toArray(Object[]::new));
    }

    public EventRule onPutObject(String name, @Nullable IEventRuleTarget target, @Nullable String path) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required"), target, path});
    }

    public EventRule onPutObject(String name, @Nullable IEventRuleTarget target) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required"), target});
    }

    public EventRule onPutObject(String name) {
        return (EventRule)this.jsiiCall("onPutObject", EventRule.class, new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    public String urlForObject(@Nullable String key) {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[]{key});
    }

    public String urlForObject() {
        return (String)this.jsiiCall("urlForObject", String.class, new Object[0]);
    }

    public String getBucketArn() {
        return (String)this.jsiiGet("bucketArn", String.class);
    }

    public String getBucketDomainName() {
        return (String)this.jsiiGet("bucketDomainName", String.class);
    }

    public String getBucketDualStackDomainName() {
        return (String)this.jsiiGet("bucketDualStackDomainName", String.class);
    }

    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public String getBucketRegionalDomainName() {
        return (String)this.jsiiGet("bucketRegionalDomainName", String.class);
    }

    public String getBucketUrl() {
        return (String)this.jsiiGet("bucketUrl", String.class);
    }

    public String getBucketWebsiteUrl() {
        return (String)this.jsiiGet("bucketWebsiteUrl", String.class);
    }

    @Nullable
    public IEncryptionKey getEncryptionKey() {
        return (IEncryptionKey)this.jsiiGet("encryptionKey", IEncryptionKey.class);
    }

    protected Boolean getAutoCreatePolicy() {
        return (Boolean)this.jsiiGet("autoCreatePolicy", Boolean.class);
    }

    protected void setAutoCreatePolicy(Boolean value) {
        this.jsiiSet("autoCreatePolicy", Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    @Nullable
    protected Boolean getDisallowPublicAccess() {
        return (Boolean)this.jsiiGet("disallowPublicAccess", Boolean.class);
    }

    protected void setDisallowPublicAccess(@Nullable Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    @Nullable
    public BucketPolicy getPolicy() {
        return (BucketPolicy)((Object)this.jsiiGet("policy", BucketPolicy.class));
    }

    public void setPolicy(@Nullable BucketPolicy value) {
        this.jsiiSet("policy", (Object)value);
    }
}

