/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineSourceActionProps
extends JsiiSerializable,
CommonPipelineSourceActionProps {
    public IBucket getBucket();

    public void setBucket(IBucket var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        private String _bucketKey;
        @Nullable
        private String _outputArtifactName;
        @Nullable
        private Boolean _pollForSourceChanges;
        private String _actionName;
        @Nullable
        private Number _runOrder;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withBucketKey(String value) {
            this._bucketKey = Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }

        public Builder withOutputArtifactName(@Nullable String value) {
            this._outputArtifactName = value;
            return this;
        }

        public Builder withPollForSourceChanges(@Nullable Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }

        public Builder withActionName(String value) {
            this._actionName = Objects.requireNonNull(value, "actionName is required");
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public PipelineSourceActionProps build() {
            return new PipelineSourceActionProps(){
                private IBucket $bucket;
                private String $bucketKey;
                @Nullable
                private String $outputArtifactName;
                @Nullable
                private Boolean $pollForSourceChanges;
                private String $actionName;
                @Nullable
                private Number $runOrder;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$bucketKey = Objects.requireNonNull(_bucketKey, "bucketKey is required");
                    this.$outputArtifactName = _outputArtifactName;
                    this.$pollForSourceChanges = _pollForSourceChanges;
                    this.$actionName = Objects.requireNonNull(_actionName, "actionName is required");
                    this.$runOrder = _runOrder;
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(IBucket value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(String value) {
                    this.$bucketKey = Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public void setOutputArtifactName(@Nullable String value) {
                    this.$outputArtifactName = value;
                }

                @Override
                public Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@Nullable Boolean value) {
                    this.$pollForSourceChanges = value;
                }

                public String getActionName() {
                    return this.$actionName;
                }

                public void setActionName(String value) {
                    this.$actionName = Objects.requireNonNull(value, "actionName is required");
                }

                public Number getRunOrder() {
                    return this.$runOrder;
                }

                public void setRunOrder(@Nullable Number value) {
                    this.$runOrder = value;
                }
            };
        }
    }
}

