/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.s3.;
import software.amazon.awscdk.services.s3.CfnBucketProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBucket.class, (String)"resourceTypeName", String.class);

    protected CfnBucket(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnBucket(Construct scope, String id, @Nullable CfnBucketProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))), Stream.of(props)).toArray());
    }

    public CfnBucket(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public String getBucketArn() {
        return (String)this.jsiiGet("bucketArn", String.class);
    }

    public String getBucketDomainName() {
        return (String)this.jsiiGet("bucketDomainName", String.class);
    }

    public String getBucketDualStackDomainName() {
        return (String)this.jsiiGet("bucketDualStackDomainName", String.class);
    }

    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public String getBucketRegionalDomainName() {
        return (String)this.jsiiGet("bucketRegionalDomainName", String.class);
    }

    public String getBucketWebsiteUrl() {
        return (String)this.jsiiGet("bucketWebsiteUrl", String.class);
    }

    public CfnBucketProps getPropertyOverrides() {
        return (CfnBucketProps)this.jsiiGet("propertyOverrides", CfnBucketProps.class);
    }

    public static interface WebsiteConfigurationProperty
    extends JsiiSerializable {
        public String getErrorDocument();

        public void setErrorDocument(String var1);

        public String getIndexDocument();

        public void setIndexDocument(String var1);

        public Object getRedirectAllRequestsTo();

        public void setRedirectAllRequestsTo(Token var1);

        public void setRedirectAllRequestsTo(RedirectAllRequestsToProperty var1);

        public Object getRoutingRules();

        public void setRoutingRules(Token var1);

        public void setRoutingRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _errorDocument;
            @Nullable
            private String _indexDocument;
            @Nullable
            private Object _redirectAllRequestsTo;
            @Nullable
            private Object _routingRules;

            public Builder withErrorDocument(@Nullable String value) {
                this._errorDocument = value;
                return this;
            }

            public Builder withIndexDocument(@Nullable String value) {
                this._indexDocument = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable Token value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRedirectAllRequestsTo(@Nullable RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable Token value) {
                this._routingRules = value;
                return this;
            }

            public Builder withRoutingRules(@Nullable List<Object> value) {
                this._routingRules = value;
                return this;
            }

            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty(){
                    @Nullable
                    private String $errorDocument;
                    @Nullable
                    private String $indexDocument;
                    @Nullable
                    private Object $redirectAllRequestsTo;
                    @Nullable
                    private Object $routingRules;
                    {
                        this.$errorDocument = _errorDocument;
                        this.$indexDocument = _indexDocument;
                        this.$redirectAllRequestsTo = _redirectAllRequestsTo;
                        this.$routingRules = _routingRules;
                    }

                    @Override
                    public String getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public void setErrorDocument(@Nullable String value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public String getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public void setIndexDocument(@Nullable String value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@Nullable Token value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@Nullable RedirectAllRequestsToProperty value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    @Override
                    public void setRoutingRules(@Nullable Token value) {
                        this.$routingRules = value;
                    }

                    @Override
                    public void setRoutingRules(@Nullable List<Object> value) {
                        this.$routingRules = value;
                    }
                };
            }
        }
    }

    public static interface VersioningConfigurationProperty
    extends JsiiSerializable {
        public String getStatus();

        public void setStatus(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty(){
                    private String $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }
                };
            }
        }
    }

    public static interface TransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public void setStorageClass(String var1);

        public Object getTransitionDate();

        public void setTransitionDate(Token var1);

        public void setTransitionDate(Instant var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _storageClass;
            @Nullable
            private Object _transitionDate;
            @Nullable
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionDate(@Nullable Token value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionDate(@Nullable Instant value) {
                this._transitionDate = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable Number value) {
                this._transitionInDays = value;
                return this;
            }

            public Builder withTransitionInDays(@Nullable Token value) {
                this._transitionInDays = value;
                return this;
            }

            public TransitionProperty build() {
                return new TransitionProperty(){
                    private String $storageClass;
                    @Nullable
                    private Object $transitionDate;
                    @Nullable
                    private Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionDate = _transitionDate;
                        this.$transitionInDays = _transitionInDays;
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(String value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public void setTransitionDate(@Nullable Token value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public void setTransitionDate(@Nullable Instant value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(@Nullable Number value) {
                        this.$transitionInDays = value;
                    }

                    @Override
                    public void setTransitionInDays(@Nullable Token value) {
                        this.$transitionInDays = value;
                    }
                };
            }
        }
    }

    public static interface TopicConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public void setEvent(String var1);

        public String getTopic();

        public void setTopic(String var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _topic;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withTopic(String value) {
                this._topic = Objects.requireNonNull(value, "topic is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty(){
                    private String $event;
                    private String $topic;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$topic = Objects.requireNonNull(_topic, "topic is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public String getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public void setTopic(String value) {
                        this.$topic = Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface TagFilterProperty
    extends JsiiSerializable {
        public String getKey();

        public void setKey(String var1);

        public String getValue();

        public void setValue(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _key;
            private String _value;

            public Builder withKey(String value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public TagFilterProperty build() {
                return new TagFilterProperty(){
                    private String $key;
                    private String $value;
                    {
                        this.$key = Objects.requireNonNull(_key, "key is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(String value) {
                        this.$key = Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(String value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }
                };
            }
        }
    }

    public static interface StorageClassAnalysisProperty
    extends JsiiSerializable {
        public Object getDataExport();

        public void setDataExport(Token var1);

        public void setDataExport(DataExportProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _dataExport;

            public Builder withDataExport(@Nullable Token value) {
                this._dataExport = value;
                return this;
            }

            public Builder withDataExport(@Nullable DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty(){
                    @Nullable
                    private Object $dataExport;
                    {
                        this.$dataExport = _dataExport;
                    }

                    @Override
                    public Object getDataExport() {
                        return this.$dataExport;
                    }

                    @Override
                    public void setDataExport(@Nullable Token value) {
                        this.$dataExport = value;
                    }

                    @Override
                    public void setDataExport(@Nullable DataExportProperty value) {
                        this.$dataExport = value;
                    }
                };
            }
        }
    }

    public static interface SseKmsEncryptedObjectsProperty
    extends JsiiSerializable {
        public String getStatus();

        public void setStatus(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty(){
                    private String $status;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }
                };
            }
        }
    }

    public static interface SourceSelectionCriteriaProperty
    extends JsiiSerializable {
        public Object getSseKmsEncryptedObjects();

        public void setSseKmsEncryptedObjects(Token var1);

        public void setSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _sseKmsEncryptedObjects;

            public Builder withSseKmsEncryptedObjects(Token value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public Builder withSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty(){
                    private Object $sseKmsEncryptedObjects;
                    {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(Token value) {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(SseKmsEncryptedObjectsProperty value) {
                        this.$sseKmsEncryptedObjects = Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionRuleProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionByDefault();

        public void setServerSideEncryptionByDefault(Token var1);

        public void setServerSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _serverSideEncryptionByDefault;

            public Builder withServerSideEncryptionByDefault(@Nullable Token value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public Builder withServerSideEncryptionByDefault(@Nullable ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty(){
                    @Nullable
                    private Object $serverSideEncryptionByDefault;
                    {
                        this.$serverSideEncryptionByDefault = _serverSideEncryptionByDefault;
                    }

                    @Override
                    public Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@Nullable Token value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@Nullable ServerSideEncryptionByDefaultProperty value) {
                        this.$serverSideEncryptionByDefault = value;
                    }
                };
            }
        }
    }

    public static interface ServerSideEncryptionByDefaultProperty
    extends JsiiSerializable {
        public String getSseAlgorithm();

        public void setSseAlgorithm(String var1);

        public String getKmsMasterKeyId();

        public void setKmsMasterKeyId(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _sseAlgorithm;
            @Nullable
            private String _kmsMasterKeyId;

            public Builder withSseAlgorithm(String value) {
                this._sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }

            public Builder withKmsMasterKeyId(@Nullable String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty(){
                    private String $sseAlgorithm;
                    @Nullable
                    private String $kmsMasterKeyId;
                    {
                        this.$sseAlgorithm = Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                        this.$kmsMasterKeyId = _kmsMasterKeyId;
                    }

                    @Override
                    public String getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public void setSseAlgorithm(String value) {
                        this.$sseAlgorithm = Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public String getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    @Override
                    public void setKmsMasterKeyId(@Nullable String value) {
                        this.$kmsMasterKeyId = value;
                    }
                };
            }
        }
    }

    public static interface S3KeyFilterProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty(){
                    private Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(Token value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface RuleProperty
    extends JsiiSerializable {
        public String getStatus();

        public void setStatus(String var1);

        public Object getAbortIncompleteMultipartUpload();

        public void setAbortIncompleteMultipartUpload(Token var1);

        public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty var1);

        public Object getExpirationDate();

        public void setExpirationDate(Token var1);

        public void setExpirationDate(Instant var1);

        public Object getExpirationInDays();

        public void setExpirationInDays(Number var1);

        public void setExpirationInDays(Token var1);

        public String getId();

        public void setId(String var1);

        public Object getNoncurrentVersionExpirationInDays();

        public void setNoncurrentVersionExpirationInDays(Number var1);

        public void setNoncurrentVersionExpirationInDays(Token var1);

        public Object getNoncurrentVersionTransition();

        public void setNoncurrentVersionTransition(Token var1);

        public void setNoncurrentVersionTransition(NoncurrentVersionTransitionProperty var1);

        public Object getNoncurrentVersionTransitions();

        public void setNoncurrentVersionTransitions(Token var1);

        public void setNoncurrentVersionTransitions(List<Object> var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public Object getTransition();

        public void setTransition(Token var1);

        public void setTransition(TransitionProperty var1);

        public Object getTransitions();

        public void setTransitions(Token var1);

        public void setTransitions(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _status;
            @Nullable
            private Object _abortIncompleteMultipartUpload;
            @Nullable
            private Object _expirationDate;
            @Nullable
            private Object _expirationInDays;
            @Nullable
            private String _id;
            @Nullable
            private Object _noncurrentVersionExpirationInDays;
            @Nullable
            private Object _noncurrentVersionTransition;
            @Nullable
            private Object _noncurrentVersionTransitions;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;
            @Nullable
            private Object _transition;
            @Nullable
            private Object _transitions;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable Token value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withAbortIncompleteMultipartUpload(@Nullable AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable Token value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationDate(@Nullable Instant value) {
                this._expirationDate = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable Number value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withExpirationInDays(@Nullable Token value) {
                this._expirationInDays = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionExpirationInDays(@Nullable Token value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable Token value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransition(@Nullable NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable Token value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withNoncurrentVersionTransitions(@Nullable List<Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTransition(@Nullable Token value) {
                this._transition = value;
                return this;
            }

            public Builder withTransition(@Nullable TransitionProperty value) {
                this._transition = value;
                return this;
            }

            public Builder withTransitions(@Nullable Token value) {
                this._transitions = value;
                return this;
            }

            public Builder withTransitions(@Nullable List<Object> value) {
                this._transitions = value;
                return this;
            }

            public RuleProperty build() {
                return new RuleProperty(){
                    private String $status;
                    @Nullable
                    private Object $abortIncompleteMultipartUpload;
                    @Nullable
                    private Object $expirationDate;
                    @Nullable
                    private Object $expirationInDays;
                    @Nullable
                    private String $id;
                    @Nullable
                    private Object $noncurrentVersionExpirationInDays;
                    @Nullable
                    private Object $noncurrentVersionTransition;
                    @Nullable
                    private Object $noncurrentVersionTransitions;
                    @Nullable
                    private String $prefix;
                    @Nullable
                    private Object $tagFilters;
                    @Nullable
                    private Object $transition;
                    @Nullable
                    private Object $transitions;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                        this.$expirationDate = _expirationDate;
                        this.$expirationInDays = _expirationInDays;
                        this.$id = _id;
                        this.$noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                        this.$noncurrentVersionTransition = _noncurrentVersionTransition;
                        this.$noncurrentVersionTransitions = _noncurrentVersionTransitions;
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                        this.$transition = _transition;
                        this.$transitions = _transitions;
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@Nullable Token value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@Nullable AbortIncompleteMultipartUploadProperty value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public void setExpirationDate(@Nullable Token value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public void setExpirationDate(@Nullable Instant value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public void setExpirationInDays(@Nullable Number value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public void setExpirationInDays(@Nullable Token value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@Nullable Number value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@Nullable Token value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@Nullable Token value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@Nullable NoncurrentVersionTransitionProperty value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@Nullable Token value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@Nullable List<Object> value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public void setTransition(@Nullable Token value) {
                        this.$transition = value;
                    }

                    @Override
                    public void setTransition(@Nullable TransitionProperty value) {
                        this.$transition = value;
                    }

                    @Override
                    public Object getTransitions() {
                        return this.$transitions;
                    }

                    @Override
                    public void setTransitions(@Nullable Token value) {
                        this.$transitions = value;
                    }

                    @Override
                    public void setTransitions(@Nullable List<Object> value) {
                        this.$transitions = value;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleProperty
    extends JsiiSerializable {
        public Object getRedirectRule();

        public void setRedirectRule(Token var1);

        public void setRedirectRule(RedirectRuleProperty var1);

        public Object getRoutingRuleCondition();

        public void setRoutingRuleCondition(Token var1);

        public void setRoutingRuleCondition(RoutingRuleConditionProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _redirectRule;
            @Nullable
            private Object _routingRuleCondition;

            public Builder withRedirectRule(Token value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRedirectRule(RedirectRuleProperty value) {
                this._redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable Token value) {
                this._routingRuleCondition = value;
                return this;
            }

            public Builder withRoutingRuleCondition(@Nullable RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            public RoutingRuleProperty build() {
                return new RoutingRuleProperty(){
                    private Object $redirectRule;
                    @Nullable
                    private Object $routingRuleCondition;
                    {
                        this.$redirectRule = Objects.requireNonNull(_redirectRule, "redirectRule is required");
                        this.$routingRuleCondition = _routingRuleCondition;
                    }

                    @Override
                    public Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public void setRedirectRule(Token value) {
                        this.$redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public void setRedirectRule(RedirectRuleProperty value) {
                        this.$redirectRule = Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    @Override
                    public void setRoutingRuleCondition(@Nullable Token value) {
                        this.$routingRuleCondition = value;
                    }

                    @Override
                    public void setRoutingRuleCondition(@Nullable RoutingRuleConditionProperty value) {
                        this.$routingRuleCondition = value;
                    }
                };
            }
        }
    }

    public static interface RoutingRuleConditionProperty
    extends JsiiSerializable {
        public String getHttpErrorCodeReturnedEquals();

        public void setHttpErrorCodeReturnedEquals(String var1);

        public String getKeyPrefixEquals();

        public void setKeyPrefixEquals(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _httpErrorCodeReturnedEquals;
            @Nullable
            private String _keyPrefixEquals;

            public Builder withHttpErrorCodeReturnedEquals(@Nullable String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }

            public Builder withKeyPrefixEquals(@Nullable String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty(){
                    @Nullable
                    private String $httpErrorCodeReturnedEquals;
                    @Nullable
                    private String $keyPrefixEquals;
                    {
                        this.$httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                        this.$keyPrefixEquals = _keyPrefixEquals;
                    }

                    @Override
                    public String getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@Nullable String value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public String getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    @Override
                    public void setKeyPrefixEquals(@Nullable String value) {
                        this.$keyPrefixEquals = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationRuleProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(ReplicationDestinationProperty var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public String getStatus();

        public void setStatus(String var1);

        public String getId();

        public void setId(String var1);

        public Object getSourceSelectionCriteria();

        public void setSourceSelectionCriteria(Token var1);

        public void setSourceSelectionCriteria(SourceSelectionCriteriaProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private String _prefix;
            private String _status;
            @Nullable
            private String _id;
            @Nullable
            private Object _sourceSelectionCriteria;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(ReplicationDestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withPrefix(String value) {
                this._prefix = Objects.requireNonNull(value, "prefix is required");
                return this;
            }

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable Token value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public Builder withSourceSelectionCriteria(@Nullable SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty(){
                    private Object $destination;
                    private String $prefix;
                    private String $status;
                    @Nullable
                    private String $id;
                    @Nullable
                    private Object $sourceSelectionCriteria;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$prefix = Objects.requireNonNull(_prefix, "prefix is required");
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$id = _id;
                        this.$sourceSelectionCriteria = _sourceSelectionCriteria;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(Token value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(ReplicationDestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(String value) {
                        this.$prefix = Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@Nullable Token value) {
                        this.$sourceSelectionCriteria = value;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@Nullable SourceSelectionCriteriaProperty value) {
                        this.$sourceSelectionCriteria = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationDestinationProperty
    extends JsiiSerializable {
        public String getBucket();

        public void setBucket(String var1);

        public Object getAccessControlTranslation();

        public void setAccessControlTranslation(Token var1);

        public void setAccessControlTranslation(AccessControlTranslationProperty var1);

        public String getAccount();

        public void setAccount(String var1);

        public Object getEncryptionConfiguration();

        public void setEncryptionConfiguration(Token var1);

        public void setEncryptionConfiguration(EncryptionConfigurationProperty var1);

        public String getStorageClass();

        public void setStorageClass(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucket;
            @Nullable
            private Object _accessControlTranslation;
            @Nullable
            private String _account;
            @Nullable
            private Object _encryptionConfiguration;
            @Nullable
            private String _storageClass;

            public Builder withBucket(String value) {
                this._bucket = Objects.requireNonNull(value, "bucket is required");
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable Token value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccessControlTranslation(@Nullable AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }

            public Builder withAccount(@Nullable String value) {
                this._account = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable Token value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }

            public Builder withStorageClass(@Nullable String value) {
                this._storageClass = value;
                return this;
            }

            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty(){
                    private String $bucket;
                    @Nullable
                    private Object $accessControlTranslation;
                    @Nullable
                    private String $account;
                    @Nullable
                    private Object $encryptionConfiguration;
                    @Nullable
                    private String $storageClass;
                    {
                        this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                        this.$accessControlTranslation = _accessControlTranslation;
                        this.$account = _account;
                        this.$encryptionConfiguration = _encryptionConfiguration;
                        this.$storageClass = _storageClass;
                    }

                    @Override
                    public String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(String value) {
                        this.$bucket = Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public void setAccessControlTranslation(@Nullable Token value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public void setAccessControlTranslation(@Nullable AccessControlTranslationProperty value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public String getAccount() {
                        return this.$account;
                    }

                    @Override
                    public void setAccount(@Nullable String value) {
                        this.$account = value;
                    }

                    @Override
                    public Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public void setEncryptionConfiguration(@Nullable Token value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public void setEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(@Nullable String value) {
                        this.$storageClass = value;
                    }
                };
            }
        }
    }

    public static interface ReplicationConfigurationProperty
    extends JsiiSerializable {
        public String getRole();

        public void setRole(String var1);

        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _role;
            private Object _rules;

            public Builder withRole(String value) {
                this._role = Objects.requireNonNull(value, "role is required");
                return this;
            }

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty(){
                    private String $role;
                    private Object $rules;
                    {
                        this.$role = Objects.requireNonNull(_role, "role is required");
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public String getRole() {
                        return this.$role;
                    }

                    @Override
                    public void setRole(String value) {
                        this.$role = Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(Token value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface RedirectRuleProperty
    extends JsiiSerializable {
        public String getHostName();

        public void setHostName(String var1);

        public String getHttpRedirectCode();

        public void setHttpRedirectCode(String var1);

        public String getProtocol();

        public void setProtocol(String var1);

        public String getReplaceKeyPrefixWith();

        public void setReplaceKeyPrefixWith(String var1);

        public String getReplaceKeyWith();

        public void setReplaceKeyWith(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _hostName;
            @Nullable
            private String _httpRedirectCode;
            @Nullable
            private String _protocol;
            @Nullable
            private String _replaceKeyPrefixWith;
            @Nullable
            private String _replaceKeyWith;

            public Builder withHostName(@Nullable String value) {
                this._hostName = value;
                return this;
            }

            public Builder withHttpRedirectCode(@Nullable String value) {
                this._httpRedirectCode = value;
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public Builder withReplaceKeyPrefixWith(@Nullable String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }

            public Builder withReplaceKeyWith(@Nullable String value) {
                this._replaceKeyWith = value;
                return this;
            }

            public RedirectRuleProperty build() {
                return new RedirectRuleProperty(){
                    @Nullable
                    private String $hostName;
                    @Nullable
                    private String $httpRedirectCode;
                    @Nullable
                    private String $protocol;
                    @Nullable
                    private String $replaceKeyPrefixWith;
                    @Nullable
                    private String $replaceKeyWith;
                    {
                        this.$hostName = _hostName;
                        this.$httpRedirectCode = _httpRedirectCode;
                        this.$protocol = _protocol;
                        this.$replaceKeyPrefixWith = _replaceKeyPrefixWith;
                        this.$replaceKeyWith = _replaceKeyWith;
                    }

                    @Override
                    public String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(@Nullable String value) {
                        this.$hostName = value;
                    }

                    @Override
                    public String getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public void setHttpRedirectCode(@Nullable String value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@Nullable String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public String getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@Nullable String value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public String getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    @Override
                    public void setReplaceKeyWith(@Nullable String value) {
                        this.$replaceKeyWith = value;
                    }
                };
            }
        }
    }

    public static interface RedirectAllRequestsToProperty
    extends JsiiSerializable {
        public String getHostName();

        public void setHostName(String var1);

        public String getProtocol();

        public void setProtocol(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _hostName;
            @Nullable
            private String _protocol;

            public Builder withHostName(String value) {
                this._hostName = Objects.requireNonNull(value, "hostName is required");
                return this;
            }

            public Builder withProtocol(@Nullable String value) {
                this._protocol = value;
                return this;
            }

            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty(){
                    private String $hostName;
                    @Nullable
                    private String $protocol;
                    {
                        this.$hostName = Objects.requireNonNull(_hostName, "hostName is required");
                        this.$protocol = _protocol;
                    }

                    @Override
                    public String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(String value) {
                        this.$hostName = Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@Nullable String value) {
                        this.$protocol = value;
                    }
                };
            }
        }
    }

    public static interface QueueConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public void setEvent(String var1);

        public String getQueue();

        public void setQueue(String var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _queue;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withQueue(String value) {
                this._queue = Objects.requireNonNull(value, "queue is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty(){
                    private String $event;
                    private String $queue;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$queue = Objects.requireNonNull(_queue, "queue is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public void setQueue(String value) {
                        this.$queue = Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        public Object getBlockPublicAcls();

        public void setBlockPublicAcls(Boolean var1);

        public void setBlockPublicAcls(Token var1);

        public Object getBlockPublicPolicy();

        public void setBlockPublicPolicy(Boolean var1);

        public void setBlockPublicPolicy(Token var1);

        public Object getIgnorePublicAcls();

        public void setIgnorePublicAcls(Boolean var1);

        public void setIgnorePublicAcls(Token var1);

        public Object getRestrictPublicBuckets();

        public void setRestrictPublicBuckets(Boolean var1);

        public void setRestrictPublicBuckets(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _blockPublicAcls;
            @Nullable
            private Object _blockPublicPolicy;
            @Nullable
            private Object _ignorePublicAcls;
            @Nullable
            private Object _restrictPublicBuckets;

            public Builder withBlockPublicAcls(@Nullable Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }

            public Builder withBlockPublicAcls(@Nullable Token value) {
                this._blockPublicAcls = value;
                return this;
            }

            public Builder withBlockPublicPolicy(@Nullable Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }

            public Builder withBlockPublicPolicy(@Nullable Token value) {
                this._blockPublicPolicy = value;
                return this;
            }

            public Builder withIgnorePublicAcls(@Nullable Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }

            public Builder withIgnorePublicAcls(@Nullable Token value) {
                this._ignorePublicAcls = value;
                return this;
            }

            public Builder withRestrictPublicBuckets(@Nullable Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            public Builder withRestrictPublicBuckets(@Nullable Token value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty(){
                    @Nullable
                    private Object $blockPublicAcls;
                    @Nullable
                    private Object $blockPublicPolicy;
                    @Nullable
                    private Object $ignorePublicAcls;
                    @Nullable
                    private Object $restrictPublicBuckets;
                    {
                        this.$blockPublicAcls = _blockPublicAcls;
                        this.$blockPublicPolicy = _blockPublicPolicy;
                        this.$ignorePublicAcls = _ignorePublicAcls;
                        this.$restrictPublicBuckets = _restrictPublicBuckets;
                    }

                    @Override
                    public Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public void setBlockPublicAcls(@Nullable Boolean value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public void setBlockPublicAcls(@Nullable Token value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public void setBlockPublicPolicy(@Nullable Boolean value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public void setBlockPublicPolicy(@Nullable Token value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public void setIgnorePublicAcls(@Nullable Boolean value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public void setIgnorePublicAcls(@Nullable Token value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@Nullable Boolean value) {
                        this.$restrictPublicBuckets = value;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@Nullable Token value) {
                        this.$restrictPublicBuckets = value;
                    }
                };
            }
        }
    }

    public static interface NotificationFilterProperty
    extends JsiiSerializable {
        public Object getS3Key();

        public void setS3Key(Token var1);

        public void setS3Key(S3KeyFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _s3Key;

            public Builder withS3Key(Token value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public Builder withS3Key(S3KeyFilterProperty value) {
                this._s3Key = Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            public NotificationFilterProperty build() {
                return new NotificationFilterProperty(){
                    private Object $s3Key;
                    {
                        this.$s3Key = Objects.requireNonNull(_s3Key, "s3Key is required");
                    }

                    @Override
                    public Object getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public void setS3Key(Token value) {
                        this.$s3Key = Objects.requireNonNull(value, "s3Key is required");
                    }

                    @Override
                    public void setS3Key(S3KeyFilterProperty value) {
                        this.$s3Key = Objects.requireNonNull(value, "s3Key is required");
                    }
                };
            }
        }
    }

    public static interface NotificationConfigurationProperty
    extends JsiiSerializable {
        public Object getLambdaConfigurations();

        public void setLambdaConfigurations(Token var1);

        public void setLambdaConfigurations(List<Object> var1);

        public Object getQueueConfigurations();

        public void setQueueConfigurations(Token var1);

        public void setQueueConfigurations(List<Object> var1);

        public Object getTopicConfigurations();

        public void setTopicConfigurations(Token var1);

        public void setTopicConfigurations(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _lambdaConfigurations;
            @Nullable
            private Object _queueConfigurations;
            @Nullable
            private Object _topicConfigurations;

            public Builder withLambdaConfigurations(@Nullable Token value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withLambdaConfigurations(@Nullable List<Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable Token value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withQueueConfigurations(@Nullable List<Object> value) {
                this._queueConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable Token value) {
                this._topicConfigurations = value;
                return this;
            }

            public Builder withTopicConfigurations(@Nullable List<Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty(){
                    @Nullable
                    private Object $lambdaConfigurations;
                    @Nullable
                    private Object $queueConfigurations;
                    @Nullable
                    private Object $topicConfigurations;
                    {
                        this.$lambdaConfigurations = _lambdaConfigurations;
                        this.$queueConfigurations = _queueConfigurations;
                        this.$topicConfigurations = _topicConfigurations;
                    }

                    @Override
                    public Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public void setLambdaConfigurations(@Nullable Token value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public void setLambdaConfigurations(@Nullable List<Object> value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public void setQueueConfigurations(@Nullable Token value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public void setQueueConfigurations(@Nullable List<Object> value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    @Override
                    public void setTopicConfigurations(@Nullable Token value) {
                        this.$topicConfigurations = value;
                    }

                    @Override
                    public void setTopicConfigurations(@Nullable List<Object> value) {
                        this.$topicConfigurations = value;
                    }
                };
            }
        }
    }

    public static interface NoncurrentVersionTransitionProperty
    extends JsiiSerializable {
        public String getStorageClass();

        public void setStorageClass(String var1);

        public Object getTransitionInDays();

        public void setTransitionInDays(Number var1);

        public void setTransitionInDays(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _storageClass;
            private Object _transitionInDays;

            public Builder withStorageClass(String value) {
                this._storageClass = Objects.requireNonNull(value, "storageClass is required");
                return this;
            }

            public Builder withTransitionInDays(Number value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public Builder withTransitionInDays(Token value) {
                this._transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty(){
                    private String $storageClass;
                    private Object $transitionInDays;
                    {
                        this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                        this.$transitionInDays = Objects.requireNonNull(_transitionInDays, "transitionInDays is required");
                    }

                    @Override
                    public String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(String value) {
                        this.$storageClass = Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(Number value) {
                        this.$transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                    }

                    @Override
                    public void setTransitionInDays(Token value) {
                        this.$transitionInDays = Objects.requireNonNull(value, "transitionInDays is required");
                    }
                };
            }
        }
    }

    public static interface MetricsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public void setId(String var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _id;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty(){
                    private String $id;
                    @Nullable
                    private String $prefix;
                    @Nullable
                    private Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }
                };
            }
        }
    }

    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        public String getDestinationBucketName();

        public void setDestinationBucketName(String var1);

        public String getLogFilePrefix();

        public void setLogFilePrefix(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _destinationBucketName;
            @Nullable
            private String _logFilePrefix;

            public Builder withDestinationBucketName(@Nullable String value) {
                this._destinationBucketName = value;
                return this;
            }

            public Builder withLogFilePrefix(@Nullable String value) {
                this._logFilePrefix = value;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty(){
                    @Nullable
                    private String $destinationBucketName;
                    @Nullable
                    private String $logFilePrefix;
                    {
                        this.$destinationBucketName = _destinationBucketName;
                        this.$logFilePrefix = _logFilePrefix;
                    }

                    @Override
                    public String getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public void setDestinationBucketName(@Nullable String value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public String getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    @Override
                    public void setLogFilePrefix(@Nullable String value) {
                        this.$logFilePrefix = value;
                    }
                };
            }
        }
    }

    public static interface LifecycleConfigurationProperty
    extends JsiiSerializable {
        public Object getRules();

        public void setRules(Token var1);

        public void setRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _rules;

            public Builder withRules(Token value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public Builder withRules(List<Object> value) {
                this._rules = Objects.requireNonNull(value, "rules is required");
                return this;
            }

            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty(){
                    private Object $rules;
                    {
                        this.$rules = Objects.requireNonNull(_rules, "rules is required");
                    }

                    @Override
                    public Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(Token value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(List<Object> value) {
                        this.$rules = Objects.requireNonNull(value, "rules is required");
                    }
                };
            }
        }
    }

    public static interface LambdaConfigurationProperty
    extends JsiiSerializable {
        public String getEvent();

        public void setEvent(String var1);

        public String getFunction();

        public void setFunction(String var1);

        public Object getFilter();

        public void setFilter(Token var1);

        public void setFilter(NotificationFilterProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _event;
            private String _function;
            @Nullable
            private Object _filter;

            public Builder withEvent(String value) {
                this._event = Objects.requireNonNull(value, "event is required");
                return this;
            }

            public Builder withFunction(String value) {
                this._function = Objects.requireNonNull(value, "function is required");
                return this;
            }

            public Builder withFilter(@Nullable Token value) {
                this._filter = value;
                return this;
            }

            public Builder withFilter(@Nullable NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty(){
                    private String $event;
                    private String $function;
                    @Nullable
                    private Object $filter;
                    {
                        this.$event = Objects.requireNonNull(_event, "event is required");
                        this.$function = Objects.requireNonNull(_function, "function is required");
                        this.$filter = _filter;
                    }

                    @Override
                    public String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(String value) {
                        this.$event = Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public String getFunction() {
                        return this.$function;
                    }

                    @Override
                    public void setFunction(String value) {
                        this.$function = Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@Nullable Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@Nullable NotificationFilterProperty value) {
                        this.$filter = value;
                    }
                };
            }
        }
    }

    public static interface InventoryConfigurationProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(DestinationProperty var1);

        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(Token var1);

        public String getId();

        public void setId(String var1);

        public String getIncludedObjectVersions();

        public void setIncludedObjectVersions(String var1);

        public String getScheduleFrequency();

        public void setScheduleFrequency(String var1);

        public Object getOptionalFields();

        public void setOptionalFields(Token var1);

        public void setOptionalFields(List<Object> var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private Object _enabled;
            private String _id;
            private String _includedObjectVersions;
            private String _scheduleFrequency;
            @Nullable
            private Object _optionalFields;
            @Nullable
            private String _prefix;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withEnabled(Boolean value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withEnabled(Token value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withIncludedObjectVersions(String value) {
                this._includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }

            public Builder withScheduleFrequency(String value) {
                this._scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }

            public Builder withOptionalFields(@Nullable Token value) {
                this._optionalFields = value;
                return this;
            }

            public Builder withOptionalFields(@Nullable List<Object> value) {
                this._optionalFields = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty(){
                    private Object $destination;
                    private Object $enabled;
                    private String $id;
                    private String $includedObjectVersions;
                    private String $scheduleFrequency;
                    @Nullable
                    private Object $optionalFields;
                    @Nullable
                    private String $prefix;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$enabled = Objects.requireNonNull(_enabled, "enabled is required");
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$includedObjectVersions = Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                        this.$scheduleFrequency = Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                        this.$optionalFields = _optionalFields;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(Token value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(DestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(Boolean value) {
                        this.$enabled = Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(Token value) {
                        this.$enabled = Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public String getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public void setIncludedObjectVersions(String value) {
                        this.$includedObjectVersions = Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public String getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public void setScheduleFrequency(String value) {
                        this.$scheduleFrequency = Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public Object getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public void setOptionalFields(@Nullable Token value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public void setOptionalFields(@Nullable List<Object> value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }
                };
            }
        }
    }

    public static interface FilterRuleProperty
    extends JsiiSerializable {
        public String getName();

        public void setName(String var1);

        public String getValue();

        public void setValue(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _name;
            private String _value;

            public Builder withName(String value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public FilterRuleProperty build() {
                return new FilterRuleProperty(){
                    private String $name;
                    private String $value;
                    {
                        this.$name = Objects.requireNonNull(_name, "name is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                    }

                    @Override
                    public String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(String value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(String value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }
                };
            }
        }
    }

    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        public String getReplicaKmsKeyId();

        public void setReplicaKmsKeyId(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _replicaKmsKeyId;

            public Builder withReplicaKmsKeyId(String value) {
                this._replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty(){
                    private String $replicaKmsKeyId;
                    {
                        this.$replicaKmsKeyId = Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");
                    }

                    @Override
                    public String getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    @Override
                    public void setReplicaKmsKeyId(String value) {
                        this.$replicaKmsKeyId = Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }
                };
            }
        }
    }

    public static interface DestinationProperty
    extends JsiiSerializable {
        public String getBucketArn();

        public void setBucketArn(String var1);

        public String getFormat();

        public void setFormat(String var1);

        public String getBucketAccountId();

        public void setBucketAccountId(String var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _bucketArn;
            private String _format;
            @Nullable
            private String _bucketAccountId;
            @Nullable
            private String _prefix;

            public Builder withBucketArn(String value) {
                this._bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }

            public Builder withFormat(String value) {
                this._format = Objects.requireNonNull(value, "format is required");
                return this;
            }

            public Builder withBucketAccountId(@Nullable String value) {
                this._bucketAccountId = value;
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public DestinationProperty build() {
                return new DestinationProperty(){
                    private String $bucketArn;
                    private String $format;
                    @Nullable
                    private String $bucketAccountId;
                    @Nullable
                    private String $prefix;
                    {
                        this.$bucketArn = Objects.requireNonNull(_bucketArn, "bucketArn is required");
                        this.$format = Objects.requireNonNull(_format, "format is required");
                        this.$bucketAccountId = _bucketAccountId;
                        this.$prefix = _prefix;
                    }

                    @Override
                    public String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public void setBucketArn(String value) {
                        this.$bucketArn = Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public String getFormat() {
                        return this.$format;
                    }

                    @Override
                    public void setFormat(String value) {
                        this.$format = Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public String getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public void setBucketAccountId(@Nullable String value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }
                };
            }
        }
    }

    public static interface DataExportProperty
    extends JsiiSerializable {
        public Object getDestination();

        public void setDestination(Token var1);

        public void setDestination(DestinationProperty var1);

        public String getOutputSchemaVersion();

        public void setOutputSchemaVersion(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _destination;
            private String _outputSchemaVersion;

            public Builder withDestination(Token value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withDestination(DestinationProperty value) {
                this._destination = Objects.requireNonNull(value, "destination is required");
                return this;
            }

            public Builder withOutputSchemaVersion(String value) {
                this._outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            public DataExportProperty build() {
                return new DataExportProperty(){
                    private Object $destination;
                    private String $outputSchemaVersion;
                    {
                        this.$destination = Objects.requireNonNull(_destination, "destination is required");
                        this.$outputSchemaVersion = Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");
                    }

                    @Override
                    public Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(Token value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(DestinationProperty value) {
                        this.$destination = Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public String getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    @Override
                    public void setOutputSchemaVersion(String value) {
                        this.$outputSchemaVersion = Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }
                };
            }
        }
    }

    public static interface CorsRuleProperty
    extends JsiiSerializable {
        public Object getAllowedMethods();

        public void setAllowedMethods(Token var1);

        public void setAllowedMethods(List<Object> var1);

        public Object getAllowedOrigins();

        public void setAllowedOrigins(Token var1);

        public void setAllowedOrigins(List<Object> var1);

        public Object getAllowedHeaders();

        public void setAllowedHeaders(Token var1);

        public void setAllowedHeaders(List<Object> var1);

        public Object getExposedHeaders();

        public void setExposedHeaders(Token var1);

        public void setExposedHeaders(List<Object> var1);

        public String getId();

        public void setId(String var1);

        public Object getMaxAge();

        public void setMaxAge(Number var1);

        public void setMaxAge(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _allowedMethods;
            private Object _allowedOrigins;
            @Nullable
            private Object _allowedHeaders;
            @Nullable
            private Object _exposedHeaders;
            @Nullable
            private String _id;
            @Nullable
            private Object _maxAge;

            public Builder withAllowedMethods(Token value) {
                this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }

            public Builder withAllowedMethods(List<Object> value) {
                this._allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }

            public Builder withAllowedOrigins(Token value) {
                this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }

            public Builder withAllowedOrigins(List<Object> value) {
                this._allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }

            public Builder withAllowedHeaders(@Nullable Token value) {
                this._allowedHeaders = value;
                return this;
            }

            public Builder withAllowedHeaders(@Nullable List<Object> value) {
                this._allowedHeaders = value;
                return this;
            }

            public Builder withExposedHeaders(@Nullable Token value) {
                this._exposedHeaders = value;
                return this;
            }

            public Builder withExposedHeaders(@Nullable List<Object> value) {
                this._exposedHeaders = value;
                return this;
            }

            public Builder withId(@Nullable String value) {
                this._id = value;
                return this;
            }

            public Builder withMaxAge(@Nullable Number value) {
                this._maxAge = value;
                return this;
            }

            public Builder withMaxAge(@Nullable Token value) {
                this._maxAge = value;
                return this;
            }

            public CorsRuleProperty build() {
                return new CorsRuleProperty(){
                    private Object $allowedMethods;
                    private Object $allowedOrigins;
                    @Nullable
                    private Object $allowedHeaders;
                    @Nullable
                    private Object $exposedHeaders;
                    @Nullable
                    private String $id;
                    @Nullable
                    private Object $maxAge;
                    {
                        this.$allowedMethods = Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                        this.$allowedOrigins = Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                        this.$allowedHeaders = _allowedHeaders;
                        this.$exposedHeaders = _exposedHeaders;
                        this.$id = _id;
                        this.$maxAge = _maxAge;
                    }

                    @Override
                    public Object getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public void setAllowedMethods(Token value) {
                        this.$allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public void setAllowedMethods(List<Object> value) {
                        this.$allowedMethods = Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public Object getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public void setAllowedOrigins(Token value) {
                        this.$allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public void setAllowedOrigins(List<Object> value) {
                        this.$allowedOrigins = Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public Object getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public void setAllowedHeaders(@Nullable Token value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public void setAllowedHeaders(@Nullable List<Object> value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public Object getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public void setExposedHeaders(@Nullable Token value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public void setExposedHeaders(@Nullable List<Object> value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@Nullable String value) {
                        this.$id = value;
                    }

                    @Override
                    public Object getMaxAge() {
                        return this.$maxAge;
                    }

                    @Override
                    public void setMaxAge(@Nullable Number value) {
                        this.$maxAge = value;
                    }

                    @Override
                    public void setMaxAge(@Nullable Token value) {
                        this.$maxAge = value;
                    }
                };
            }
        }
    }

    public static interface CorsConfigurationProperty
    extends JsiiSerializable {
        public Object getCorsRules();

        public void setCorsRules(Token var1);

        public void setCorsRules(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _corsRules;

            public Builder withCorsRules(Token value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public Builder withCorsRules(List<Object> value) {
                this._corsRules = Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty(){
                    private Object $corsRules;
                    {
                        this.$corsRules = Objects.requireNonNull(_corsRules, "corsRules is required");
                    }

                    @Override
                    public Object getCorsRules() {
                        return this.$corsRules;
                    }

                    @Override
                    public void setCorsRules(Token value) {
                        this.$corsRules = Objects.requireNonNull(value, "corsRules is required");
                    }

                    @Override
                    public void setCorsRules(List<Object> value) {
                        this.$corsRules = Objects.requireNonNull(value, "corsRules is required");
                    }
                };
            }
        }
    }

    public static interface BucketEncryptionProperty
    extends JsiiSerializable {
        public Object getServerSideEncryptionConfiguration();

        public void setServerSideEncryptionConfiguration(Token var1);

        public void setServerSideEncryptionConfiguration(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _serverSideEncryptionConfiguration;

            public Builder withServerSideEncryptionConfiguration(Token value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public Builder withServerSideEncryptionConfiguration(List<Object> value) {
                this._serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty(){
                    private Object $serverSideEncryptionConfiguration;
                    {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(Token value) {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(List<Object> value) {
                        this.$serverSideEncryptionConfiguration = Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }
                };
            }
        }
    }

    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        public String getId();

        public void setId(String var1);

        public Object getStorageClassAnalysis();

        public void setStorageClassAnalysis(Token var1);

        public void setStorageClassAnalysis(StorageClassAnalysisProperty var1);

        public String getPrefix();

        public void setPrefix(String var1);

        public Object getTagFilters();

        public void setTagFilters(Token var1);

        public void setTagFilters(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _id;
            private Object _storageClassAnalysis;
            @Nullable
            private String _prefix;
            @Nullable
            private Object _tagFilters;

            public Builder withId(String value) {
                this._id = Objects.requireNonNull(value, "id is required");
                return this;
            }

            public Builder withStorageClassAnalysis(Token value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withStorageClassAnalysis(StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }

            public Builder withPrefix(@Nullable String value) {
                this._prefix = value;
                return this;
            }

            public Builder withTagFilters(@Nullable Token value) {
                this._tagFilters = value;
                return this;
            }

            public Builder withTagFilters(@Nullable List<Object> value) {
                this._tagFilters = value;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty(){
                    private String $id;
                    private Object $storageClassAnalysis;
                    @Nullable
                    private String $prefix;
                    @Nullable
                    private Object $tagFilters;
                    {
                        this.$id = Objects.requireNonNull(_id, "id is required");
                        this.$storageClassAnalysis = Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                        this.$prefix = _prefix;
                        this.$tagFilters = _tagFilters;
                    }

                    @Override
                    public String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(String value) {
                        this.$id = Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public void setStorageClassAnalysis(Token value) {
                        this.$storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public void setStorageClassAnalysis(StorageClassAnalysisProperty value) {
                        this.$storageClassAnalysis = Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@Nullable String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@Nullable Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@Nullable List<Object> value) {
                        this.$tagFilters = value;
                    }
                };
            }
        }
    }

    public static interface AccessControlTranslationProperty
    extends JsiiSerializable {
        public String getOwner();

        public void setOwner(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _owner;

            public Builder withOwner(String value) {
                this._owner = Objects.requireNonNull(value, "owner is required");
                return this;
            }

            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty(){
                    private String $owner;
                    {
                        this.$owner = Objects.requireNonNull(_owner, "owner is required");
                    }

                    @Override
                    public String getOwner() {
                        return this.$owner;
                    }

                    @Override
                    public void setOwner(String value) {
                        this.$owner = Objects.requireNonNull(value, "owner is required");
                    }
                };
            }
        }
    }

    public static interface AccelerateConfigurationProperty
    extends JsiiSerializable {
        public String getAccelerationStatus();

        public void setAccelerationStatus(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _accelerationStatus;

            public Builder withAccelerationStatus(String value) {
                this._accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty(){
                    private String $accelerationStatus;
                    {
                        this.$accelerationStatus = Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");
                    }

                    @Override
                    public String getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    @Override
                    public void setAccelerationStatus(String value) {
                        this.$accelerationStatus = Objects.requireNonNull(value, "accelerationStatus is required");
                    }
                };
            }
        }
    }

    public static interface AbortIncompleteMultipartUploadProperty
    extends JsiiSerializable {
        public Object getDaysAfterInitiation();

        public void setDaysAfterInitiation(Number var1);

        public void setDaysAfterInitiation(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _daysAfterInitiation;

            public Builder withDaysAfterInitiation(Number value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public Builder withDaysAfterInitiation(Token value) {
                this._daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty(){
                    private Object $daysAfterInitiation;
                    {
                        this.$daysAfterInitiation = Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");
                    }

                    @Override
                    public Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    @Override
                    public void setDaysAfterInitiation(Number value) {
                        this.$daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                    @Override
                    public void setDaysAfterInitiation(Token value) {
                        this.$daysAfterInitiation = Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }
                };
            }
        }
    }
}

