/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BucketDeploymentProps
extends JsiiSerializable {
    public IBucket getDestinationBucket();

    public ISource getSource();

    public String getDestinationKeyPrefix();

    public Boolean getRetainOnDelete();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _destinationBucket;
        private ISource _source;
        @Nullable
        private String _destinationKeyPrefix;
        @Nullable
        private Boolean _retainOnDelete;

        public Builder withDestinationBucket(IBucket value) {
            this._destinationBucket = Objects.requireNonNull(value, "destinationBucket is required");
            return this;
        }

        public Builder withSource(ISource value) {
            this._source = Objects.requireNonNull(value, "source is required");
            return this;
        }

        public Builder withDestinationKeyPrefix(@Nullable String value) {
            this._destinationKeyPrefix = value;
            return this;
        }

        public Builder withRetainOnDelete(@Nullable Boolean value) {
            this._retainOnDelete = value;
            return this;
        }

        public BucketDeploymentProps build() {
            return new BucketDeploymentProps(){
                private final IBucket $destinationBucket;
                private final ISource $source;
                @Nullable
                private final String $destinationKeyPrefix;
                @Nullable
                private final Boolean $retainOnDelete;
                {
                    this.$destinationBucket = Objects.requireNonNull(_destinationBucket, "destinationBucket is required");
                    this.$source = Objects.requireNonNull(_source, "source is required");
                    this.$destinationKeyPrefix = _destinationKeyPrefix;
                    this.$retainOnDelete = _retainOnDelete;
                }

                @Override
                public IBucket getDestinationBucket() {
                    return this.$destinationBucket;
                }

                @Override
                public ISource getSource() {
                    return this.$source;
                }

                @Override
                public String getDestinationKeyPrefix() {
                    return this.$destinationKeyPrefix;
                }

                @Override
                public Boolean getRetainOnDelete() {
                    return this.$retainOnDelete;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("destinationBucket", om.valueToTree((Object)this.getDestinationBucket()));
                    obj.set("source", om.valueToTree((Object)this.getSource()));
                    obj.set("destinationKeyPrefix", om.valueToTree((Object)this.getDestinationKeyPrefix()));
                    obj.set("retainOnDelete", om.valueToTree((Object)this.getRetainOnDelete()));
                    return obj;
                }
            };
        }
    }
}

