/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.logs.LogGroupArn;
import software.amazon.awscdk.services.route53.PublicHostedZoneProps;
import software.amazon.jsii.JsiiSerializable;

public interface PrivateHostedZoneProps
extends JsiiSerializable,
PublicHostedZoneProps {
    public VpcNetworkRef getVpc();

    public void setVpc(VpcNetworkRef var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VpcNetworkRef _vpc;
        private String _zoneName;
        @Nullable
        private String _comment;
        @Nullable
        private LogGroupArn _queryLogsLogGroupArn;

        public Builder withVpc(VpcNetworkRef value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withZoneName(String value) {
            this._zoneName = Objects.requireNonNull(value, "zoneName is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withQueryLogsLogGroupArn(@Nullable LogGroupArn value) {
            this._queryLogsLogGroupArn = value;
            return this;
        }

        public PrivateHostedZoneProps build() {
            return new PrivateHostedZoneProps(){
                private VpcNetworkRef $vpc;
                private String $zoneName;
                @Nullable
                private String $comment;
                @Nullable
                private LogGroupArn $queryLogsLogGroupArn;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$zoneName = Objects.requireNonNull(_zoneName, "zoneName is required");
                    this.$comment = _comment;
                    this.$queryLogsLogGroupArn = _queryLogsLogGroupArn;
                }

                @Override
                public VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(VpcNetworkRef value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public String getZoneName() {
                    return this.$zoneName;
                }

                @Override
                public void setZoneName(String value) {
                    this.$zoneName = Objects.requireNonNull(value, "zoneName is required");
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public void setComment(@Nullable String value) {
                    this.$comment = value;
                }

                @Override
                public LogGroupArn getQueryLogsLogGroupArn() {
                    return this.$queryLogsLogGroupArn;
                }

                @Override
                public void setQueryLogsLogGroupArn(@Nullable LogGroupArn value) {
                    this.$queryLogsLogGroupArn = value;
                }
            };
        }
    }
}

