/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.route53.CfnRecordSet;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnRecordSetProps
extends JsiiSerializable {
    public String getName();

    public String getType();

    public Object getAliasTarget();

    public String getComment();

    public String getFailover();

    public Object getGeoLocation();

    public String getHealthCheckId();

    public String getHostedZoneId();

    public String getHostedZoneName();

    public Object getMultiValueAnswer();

    public String getRegion();

    public List<String> getResourceRecords();

    public String getSetIdentifier();

    public String getTtl();

    public Number getWeight();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        private String _type;
        @Nullable
        private Object _aliasTarget;
        @Nullable
        private String _comment;
        @Nullable
        private String _failover;
        @Nullable
        private Object _geoLocation;
        @Nullable
        private String _healthCheckId;
        @Nullable
        private String _hostedZoneId;
        @Nullable
        private String _hostedZoneName;
        @Nullable
        private Object _multiValueAnswer;
        @Nullable
        private String _region;
        @Nullable
        private List<String> _resourceRecords;
        @Nullable
        private String _setIdentifier;
        @Nullable
        private String _ttl;
        @Nullable
        private Number _weight;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withType(String value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withAliasTarget(@Nullable IResolvable value) {
            this._aliasTarget = value;
            return this;
        }

        public Builder withAliasTarget(@Nullable CfnRecordSet.AliasTargetProperty value) {
            this._aliasTarget = value;
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withFailover(@Nullable String value) {
            this._failover = value;
            return this;
        }

        public Builder withGeoLocation(@Nullable IResolvable value) {
            this._geoLocation = value;
            return this;
        }

        public Builder withGeoLocation(@Nullable CfnRecordSet.GeoLocationProperty value) {
            this._geoLocation = value;
            return this;
        }

        public Builder withHealthCheckId(@Nullable String value) {
            this._healthCheckId = value;
            return this;
        }

        public Builder withHostedZoneId(@Nullable String value) {
            this._hostedZoneId = value;
            return this;
        }

        public Builder withHostedZoneName(@Nullable String value) {
            this._hostedZoneName = value;
            return this;
        }

        public Builder withMultiValueAnswer(@Nullable Boolean value) {
            this._multiValueAnswer = value;
            return this;
        }

        public Builder withMultiValueAnswer(@Nullable IResolvable value) {
            this._multiValueAnswer = value;
            return this;
        }

        public Builder withRegion(@Nullable String value) {
            this._region = value;
            return this;
        }

        public Builder withResourceRecords(@Nullable List<String> value) {
            this._resourceRecords = value;
            return this;
        }

        public Builder withSetIdentifier(@Nullable String value) {
            this._setIdentifier = value;
            return this;
        }

        public Builder withTtl(@Nullable String value) {
            this._ttl = value;
            return this;
        }

        public Builder withWeight(@Nullable Number value) {
            this._weight = value;
            return this;
        }

        public CfnRecordSetProps build() {
            return new CfnRecordSetProps(){
                private final String $name;
                private final String $type;
                @Nullable
                private final Object $aliasTarget;
                @Nullable
                private final String $comment;
                @Nullable
                private final String $failover;
                @Nullable
                private final Object $geoLocation;
                @Nullable
                private final String $healthCheckId;
                @Nullable
                private final String $hostedZoneId;
                @Nullable
                private final String $hostedZoneName;
                @Nullable
                private final Object $multiValueAnswer;
                @Nullable
                private final String $region;
                @Nullable
                private final List<String> $resourceRecords;
                @Nullable
                private final String $setIdentifier;
                @Nullable
                private final String $ttl;
                @Nullable
                private final Number $weight;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$aliasTarget = _aliasTarget;
                    this.$comment = _comment;
                    this.$failover = _failover;
                    this.$geoLocation = _geoLocation;
                    this.$healthCheckId = _healthCheckId;
                    this.$hostedZoneId = _hostedZoneId;
                    this.$hostedZoneName = _hostedZoneName;
                    this.$multiValueAnswer = _multiValueAnswer;
                    this.$region = _region;
                    this.$resourceRecords = _resourceRecords;
                    this.$setIdentifier = _setIdentifier;
                    this.$ttl = _ttl;
                    this.$weight = _weight;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getType() {
                    return this.$type;
                }

                @Override
                public Object getAliasTarget() {
                    return this.$aliasTarget;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public String getFailover() {
                    return this.$failover;
                }

                @Override
                public Object getGeoLocation() {
                    return this.$geoLocation;
                }

                @Override
                public String getHealthCheckId() {
                    return this.$healthCheckId;
                }

                @Override
                public String getHostedZoneId() {
                    return this.$hostedZoneId;
                }

                @Override
                public String getHostedZoneName() {
                    return this.$hostedZoneName;
                }

                @Override
                public Object getMultiValueAnswer() {
                    return this.$multiValueAnswer;
                }

                @Override
                public String getRegion() {
                    return this.$region;
                }

                @Override
                public List<String> getResourceRecords() {
                    return this.$resourceRecords;
                }

                @Override
                public String getSetIdentifier() {
                    return this.$setIdentifier;
                }

                @Override
                public String getTtl() {
                    return this.$ttl;
                }

                @Override
                public Number getWeight() {
                    return this.$weight;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    if (this.getAliasTarget() != null) {
                        obj.set("aliasTarget", om.valueToTree(this.getAliasTarget()));
                    }
                    if (this.getComment() != null) {
                        obj.set("comment", om.valueToTree((Object)this.getComment()));
                    }
                    if (this.getFailover() != null) {
                        obj.set("failover", om.valueToTree((Object)this.getFailover()));
                    }
                    if (this.getGeoLocation() != null) {
                        obj.set("geoLocation", om.valueToTree(this.getGeoLocation()));
                    }
                    if (this.getHealthCheckId() != null) {
                        obj.set("healthCheckId", om.valueToTree((Object)this.getHealthCheckId()));
                    }
                    if (this.getHostedZoneId() != null) {
                        obj.set("hostedZoneId", om.valueToTree((Object)this.getHostedZoneId()));
                    }
                    if (this.getHostedZoneName() != null) {
                        obj.set("hostedZoneName", om.valueToTree((Object)this.getHostedZoneName()));
                    }
                    if (this.getMultiValueAnswer() != null) {
                        obj.set("multiValueAnswer", om.valueToTree(this.getMultiValueAnswer()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree((Object)this.getRegion()));
                    }
                    if (this.getResourceRecords() != null) {
                        obj.set("resourceRecords", om.valueToTree(this.getResourceRecords()));
                    }
                    if (this.getSetIdentifier() != null) {
                        obj.set("setIdentifier", om.valueToTree((Object)this.getSetIdentifier()));
                    }
                    if (this.getTtl() != null) {
                        obj.set("ttl", om.valueToTree((Object)this.getTtl()));
                    }
                    if (this.getWeight() != null) {
                        obj.set("weight", om.valueToTree((Object)this.getWeight()));
                    }
                    return obj;
                }
            };
        }
    }
}

