/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.awscdk.services.route53.RecordSetOptions;
import software.amazon.awscdk.services.route53.SrvRecordValue;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SrvRecordProps
extends JsiiSerializable,
RecordSetOptions {
    public List<SrvRecordValue> getValues();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SrvRecordValue> _values;
        private IHostedZone _zone;
        @Nullable
        private String _comment;
        @Nullable
        private String _recordName;
        @Nullable
        private Number _ttl;

        public Builder withValues(List<SrvRecordValue> value) {
            this._values = Objects.requireNonNull(value, "values is required");
            return this;
        }

        public Builder withZone(IHostedZone value) {
            this._zone = Objects.requireNonNull(value, "zone is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withRecordName(@Nullable String value) {
            this._recordName = value;
            return this;
        }

        public Builder withTtl(@Nullable Number value) {
            this._ttl = value;
            return this;
        }

        public SrvRecordProps build() {
            return new SrvRecordProps(){
                private final List<SrvRecordValue> $values;
                private final IHostedZone $zone;
                @Nullable
                private final String $comment;
                @Nullable
                private final String $recordName;
                @Nullable
                private final Number $ttl;
                {
                    this.$values = Objects.requireNonNull(_values, "values is required");
                    this.$zone = Objects.requireNonNull(_zone, "zone is required");
                    this.$comment = _comment;
                    this.$recordName = _recordName;
                    this.$ttl = _ttl;
                }

                @Override
                public List<SrvRecordValue> getValues() {
                    return this.$values;
                }

                @Override
                public IHostedZone getZone() {
                    return this.$zone;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public String getRecordName() {
                    return this.$recordName;
                }

                @Override
                public Number getTtl() {
                    return this.$ttl;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("values", om.valueToTree(this.getValues()));
                    obj.set("zone", om.valueToTree((Object)this.getZone()));
                    if (this.getComment() != null) {
                        obj.set("comment", om.valueToTree((Object)this.getComment()));
                    }
                    if (this.getRecordName() != null) {
                        obj.set("recordName", om.valueToTree((Object)this.getRecordName()));
                    }
                    if (this.getTtl() != null) {
                        obj.set("ttl", om.valueToTree((Object)this.getTtl()));
                    }
                    return obj;
                }
            };
        }
    }
}

