/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.awscdk.services.route53.ZoneDelegationOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ZoneDelegationRecordProps
extends JsiiSerializable,
ZoneDelegationOptions {
    public String getDelegatedZoneName();

    public List<String> getNameServers();

    public IHostedZone getZone();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _delegatedZoneName;
        private List<String> _nameServers;
        private IHostedZone _zone;
        @Nullable
        private String _comment;
        @Nullable
        private Number _ttl;

        public Builder withDelegatedZoneName(String value) {
            this._delegatedZoneName = Objects.requireNonNull(value, "delegatedZoneName is required");
            return this;
        }

        public Builder withNameServers(List<String> value) {
            this._nameServers = Objects.requireNonNull(value, "nameServers is required");
            return this;
        }

        public Builder withZone(IHostedZone value) {
            this._zone = Objects.requireNonNull(value, "zone is required");
            return this;
        }

        public Builder withComment(@Nullable String value) {
            this._comment = value;
            return this;
        }

        public Builder withTtl(@Nullable Number value) {
            this._ttl = value;
            return this;
        }

        public ZoneDelegationRecordProps build() {
            return new ZoneDelegationRecordProps(){
                private final String $delegatedZoneName;
                private final List<String> $nameServers;
                private final IHostedZone $zone;
                @Nullable
                private final String $comment;
                @Nullable
                private final Number $ttl;
                {
                    this.$delegatedZoneName = Objects.requireNonNull(_delegatedZoneName, "delegatedZoneName is required");
                    this.$nameServers = Objects.requireNonNull(_nameServers, "nameServers is required");
                    this.$zone = Objects.requireNonNull(_zone, "zone is required");
                    this.$comment = _comment;
                    this.$ttl = _ttl;
                }

                @Override
                public String getDelegatedZoneName() {
                    return this.$delegatedZoneName;
                }

                @Override
                public List<String> getNameServers() {
                    return this.$nameServers;
                }

                @Override
                public IHostedZone getZone() {
                    return this.$zone;
                }

                @Override
                public String getComment() {
                    return this.$comment;
                }

                @Override
                public Number getTtl() {
                    return this.$ttl;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("delegatedZoneName", om.valueToTree((Object)this.getDelegatedZoneName()));
                    obj.set("nameServers", om.valueToTree(this.getNameServers()));
                    obj.set("zone", om.valueToTree((Object)this.getZone()));
                    obj.set("comment", om.valueToTree((Object)this.getComment()));
                    obj.set("ttl", om.valueToTree((Object)this.getTtl()));
                    return obj;
                }
            };
        }
    }
}

