/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.iam.$Module;
import software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IIdentity;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.iam.Policy;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.PrincipalPolicyFragment;
import software.amazon.awscdk.services.iam.UserAttributes;
import software.amazon.awscdk.services.iam.UserProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-iam.User")
public class User
extends Resource
implements IIdentity,
IUser {
    protected User(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected User(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public User(@NotNull Construct scope, @NotNull String id, @Nullable UserProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public User(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IUser fromUserArn(@NotNull Construct scope, @NotNull String id, @NotNull String userArn) {
        return (IUser)JsiiObject.jsiiStaticCall(User.class, (String)"fromUserArn", (NativeType)NativeType.forClass(IUser.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(userArn, "userArn is required")});
    }

    @NotNull
    public static IUser fromUserAttributes(@NotNull Construct scope, @NotNull String id, @NotNull UserAttributes attrs) {
        return (IUser)JsiiObject.jsiiStaticCall(User.class, (String)"fromUserAttributes", (NativeType)NativeType.forClass(IUser.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IUser fromUserName(@NotNull Construct scope, @NotNull String id, @NotNull String userName) {
        return (IUser)JsiiObject.jsiiStaticCall(User.class, (String)"fromUserName", (NativeType)NativeType.forClass(IUser.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(userName, "userName is required")});
    }

    @Override
    public void addManagedPolicy(@NotNull IManagedPolicy policy) {
        Kernel.call((Object)this, (String)"addManagedPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    public void addToGroup(@NotNull IGroup group) {
        Kernel.call((Object)this, (String)"addToGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(group, "group is required")});
    }

    @Override
    @NotNull
    public Boolean addToPolicy(@NotNull PolicyStatement statement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToPolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public AddToPrincipalPolicyResult addToPrincipalPolicy(@NotNull PolicyStatement statement) {
        return (AddToPrincipalPolicyResult)Kernel.call((Object)this, (String)"addToPrincipalPolicy", (NativeType)NativeType.forClass(AddToPrincipalPolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void attachInlinePolicy(@NotNull Policy policy) {
        Kernel.call((Object)this, (String)"attachInlinePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public String getAssumeRoleAction() {
        return (String)Kernel.get((Object)this, (String)"assumeRoleAction", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @NotNull
    public PrincipalPolicyFragment getPolicyFragment() {
        return (PrincipalPolicyFragment)((Object)Kernel.get((Object)this, (String)"policyFragment", (NativeType)NativeType.forClass(PrincipalPolicyFragment.class)));
    }

    @Override
    @NotNull
    public String getUserArn() {
        return (String)Kernel.get((Object)this, (String)"userArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getUserName() {
        return (String)Kernel.get((Object)this, (String)"userName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IManagedPolicy getPermissionsBoundary() {
        return (IManagedPolicy)Kernel.get((Object)this, (String)"permissionsBoundary", (NativeType)NativeType.forClass(IManagedPolicy.class));
    }

    @Override
    @Nullable
    public String getPrincipalAccount() {
        return (String)Kernel.get((Object)this, (String)"principalAccount", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<User> {
        private final Construct scope;
        private final String id;
        private UserProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder groups(List<? extends IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        public Builder managedPolicies(List<? extends IManagedPolicy> managedPolicies) {
            this.props().managedPolicies(managedPolicies);
            return this;
        }

        public Builder password(SecretValue password) {
            this.props().password(password);
            return this;
        }

        public Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.props().passwordResetRequired(passwordResetRequired);
            return this;
        }

        public Builder path(String path) {
            this.props().path(path);
            return this;
        }

        public Builder permissionsBoundary(IManagedPolicy permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder userName(String userName) {
            this.props().userName(userName);
            return this;
        }

        public User build() {
            return new User(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private UserProps.Builder props() {
            if (this.props == null) {
                this.props = new UserProps.Builder();
            }
            return this.props;
        }
    }
}

