package software.amazon.awscdk.services.iam;

/**
 * An IAM role that only gets attached to the construct tree once it gets used, not before.
 * 
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:53:22.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.LazyRole")
public class LazyRole extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IRole {
    protected LazyRole(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LazyRole(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.LazyRoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Attaches a managed policy to this role.
     * 
     * EXPERIMENTAL
     * 
     * @param policy The managed policy to attach.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        this.jsiiCall("addManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Adds a permission to the role's default policy document. If there is no default policy attached to this role, it will be created.
     * 
     * EXPERIMENTAL
     * 
     * @param statement The permission statement to add to the policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attaches a policy to this role.
     * 
     * EXPERIMENTAL
     * 
     * @param policy The policy to attach.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.iam.Grant grant(final software.amazon.awscdk.services.iam.IPrincipal identity, final java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant permissions to the given principal to pass this role.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPassRole(final software.amazon.awscdk.services.iam.IPrincipal identity) {
        return this.jsiiCall("grantPassRole", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     * Returns the ARN of this role.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    /**
     * Returns the name of this role.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }
}
