package software.amazon.awscdk.core;

/**
 * Represents a CloudFormation element that can be used within a Condition.
 * 
 * You can use intrinsic functions, such as ``Fn.conditionIf``,
 * ``Fn.conditionEquals``, and ``Fn.conditionNot``, to conditionally create
 * stack resources. These conditions are evaluated based on input parameters
 * that you declare when you create or update a stack. After you define all your
 * conditions, you can associate them with resources or resource properties in
 * the Resources and Outputs sections of a template.
 * 
 * You define all conditions in the Conditions section of a template except for
 * ``Fn.conditionIf`` conditions. You can use the ``Fn.conditionIf`` condition
 * in the metadata attribute, update policy attribute, and property values in
 * the Resources section and Outputs sections of a template.
 * 
 * You might use conditions when you want to reuse a template that can create
 * resources in different contexts, such as a test environment versus a
 * production environment. In your template, you can add an EnvironmentType
 * input parameter, which accepts either prod or test as inputs. For the
 * production environment, you might include Amazon EC2 instances with certain
 * capabilities; however, for the test environment, you want to use less
 * capabilities to save costs. With conditions, you can define which resources
 * are created and how they're configured for each environment type.
 * 
 * You can use `toString` when you wish to embed a condition expression
 * in a property value that accepts a `string`. For example:
 * 
 * ```ts
 * new sqs.Queue(this, 'MyQueue', {
 *    queueName: Fn.conditionIf('Condition', 'Hello', 'World').toString()
 * });
 * ```
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:04:46.910Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ICfnConditionExpression extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResolvable {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.ICfnConditionExpression {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         * The creation stack of this resolvable which will be appended to errors thrown during resolution.
         * 
         * If this returns an empty array the stack will not be attached.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getCreationStack() {
            return this.jsiiGet("creationStack", java.util.List.class);
        }

        /**
         * Produce the Token's value at resolution time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public java.lang.Object resolve(final software.amazon.awscdk.core.IResolveContext context) {
            return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }

        /**
         * Return a string representation of this resolvable object.
         * 
         * Returns a reversible string representation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public java.lang.String toString() {
            return this.jsiiCall("toString", java.lang.String.class);
        }
    }
}
