package software.amazon.awscdk.core;

/**
 * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:04:46.892Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeDeployLambdaAliasUpdate extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getApplicationName();

    /**
     * The name of the AWS CodeDeploy deployment group.
     * 
     * This is where the traffic-shifting policy is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentGroupName();

    /**
     * The name of the Lambda function to run after traffic routing completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAfterAllowTrafficHook();

    /**
     * The name of the Lambda function to run before traffic routing starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBeforeAllowTrafficHook();

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String applicationName;
        private java.lang.String deploymentGroupName;
        private java.lang.String afterAllowTrafficHook;
        private java.lang.String beforeAllowTrafficHook;

        /**
         * Sets the value of ApplicationName
         * @param applicationName The name of the AWS CodeDeploy application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of DeploymentGroupName
         * @param deploymentGroupName The name of the AWS CodeDeploy deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(java.lang.String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        /**
         * Sets the value of AfterAllowTrafficHook
         * @param afterAllowTrafficHook The name of the Lambda function to run after traffic routing completes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder afterAllowTrafficHook(java.lang.String afterAllowTrafficHook) {
            this.afterAllowTrafficHook = afterAllowTrafficHook;
            return this;
        }

        /**
         * Sets the value of BeforeAllowTrafficHook
         * @param beforeAllowTrafficHook The name of the Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder beforeAllowTrafficHook(java.lang.String beforeAllowTrafficHook) {
            this.beforeAllowTrafficHook = beforeAllowTrafficHook;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployLambdaAliasUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnCodeDeployLambdaAliasUpdate build() {
            return new Jsii$Proxy(applicationName, deploymentGroupName, afterAllowTrafficHook, beforeAllowTrafficHook);
        }

    }

    /**
     * An implementation for {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeDeployLambdaAliasUpdate {
        private final java.lang.String applicationName;
        private final java.lang.String deploymentGroupName;
        private final java.lang.String afterAllowTrafficHook;
        private final java.lang.String beforeAllowTrafficHook;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.deploymentGroupName = this.jsiiGet("deploymentGroupName", java.lang.String.class);
            this.afterAllowTrafficHook = this.jsiiGet("afterAllowTrafficHook", java.lang.String.class);
            this.beforeAllowTrafficHook = this.jsiiGet("beforeAllowTrafficHook", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String applicationName, java.lang.String deploymentGroupName, java.lang.String afterAllowTrafficHook, java.lang.String beforeAllowTrafficHook) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.deploymentGroupName = java.util.Objects.requireNonNull(deploymentGroupName, "deploymentGroupName is required");
            this.afterAllowTrafficHook = afterAllowTrafficHook;
            this.beforeAllowTrafficHook = beforeAllowTrafficHook;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public java.lang.String getAfterAllowTrafficHook() {
            return this.afterAllowTrafficHook;
        }

        @Override
        public java.lang.String getBeforeAllowTrafficHook() {
            return this.beforeAllowTrafficHook;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("applicationName", om.valueToTree(this.getApplicationName()));
            obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
            if (this.getAfterAllowTrafficHook() != null) {
                obj.set("afterAllowTrafficHook", om.valueToTree(this.getAfterAllowTrafficHook()));
            }
            if (this.getBeforeAllowTrafficHook() != null) {
                obj.set("beforeAllowTrafficHook", om.valueToTree(this.getBeforeAllowTrafficHook()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeDeployLambdaAliasUpdate.Jsii$Proxy that = (CfnCodeDeployLambdaAliasUpdate.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!deploymentGroupName.equals(that.deploymentGroupName)) return false;
            if (this.afterAllowTrafficHook != null ? !this.afterAllowTrafficHook.equals(that.afterAllowTrafficHook) : that.afterAllowTrafficHook != null) return false;
            return this.beforeAllowTrafficHook != null ? this.beforeAllowTrafficHook.equals(that.beforeAllowTrafficHook) : that.beforeAllowTrafficHook == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.deploymentGroupName.hashCode());
            result = 31 * result + (this.afterAllowTrafficHook != null ? this.afterAllowTrafficHook.hashCode() : 0);
            result = 31 * result + (this.beforeAllowTrafficHook != null ? this.beforeAllowTrafficHook.hashCode() : 0);
            return result;
        }

    }
}
