package software.amazon.awscdk.core;

/**
 * A construct which represents an entire CDK app. This construct is normally the root of the construct tree.
 * 
 * You would normally define an `App` instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 * 
 * After all the child constructs are defined within the app, you should call
 * `app.synth()` which will emit a "cloud assembly" from this app into the
 * directory specified by `outdir`. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 * 
 * @see https://docs.aws.amazon.com/cdk/latest/guide/apps_and_stacks.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:04:46.884Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.App")
public class App extends software.amazon.awscdk.core.Construct {

    protected App(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    /**
     * Initializes a CDK application.
     * 
     * @param props initialization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App(final software.amazon.awscdk.core.AppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props }));
    }
    /**
     * Initializes a CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this));
    }

    /**
     * Checks if an object is an instance of the `App` class.
     * 
     * @return `true` if `obj` is an `App`.
     * @param obj The object to evaluate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isApp(final java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.App.class, "isApp", java.lang.Boolean.class, new Object[] { obj });
    }

    /**
     * Synthesizes a cloud assembly for this app.
     * 
     * Emits it to the directory
     * specified by `outdir`.
     * 
     * @return a `CloudAssembly` which can be used to inspect synthesized
     * artifacts such as CloudFormation templates and assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.cxapi.CloudAssembly synth() {
        return this.jsiiCall("synth", software.amazon.awscdk.cxapi.CloudAssembly.class);
    }
}
