package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T00:51:58.981Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AWS environment (account/region) where this stack will be deployed.
     * 
     * Default: - The `default-account` and `default-region` context parameters will be
     * used. If they are undefined, it will not be possible to deploy the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Environment getEnv();

    /**
     * Name to deploy the stack with.
     * 
     * Default: - Derived from construct path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getStackName();

    /**
     * Stack tags that will be applied to all the taggable resources and the stack itself.
     * 
     * Default: {}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getTags();

    /**
     * @return a {@link Builder} of {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.core.Environment env;
        private java.lang.String stackName;
        private java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of Env
         * @param env The AWS environment (account/region) where this stack will be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(software.amazon.awscdk.core.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of StackName
         * @param stackName Name to deploy the stack with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public StackProps build() {
            return new Jsii$Proxy(env, stackName, tags);
        }

    }

    /**
     * An implementation for {@link StackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackProps {
        private final software.amazon.awscdk.core.Environment env;
        private final java.lang.String stackName;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.env = this.jsiiGet("env", software.amazon.awscdk.core.Environment.class);
            this.stackName = this.jsiiGet("stackName", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.Map.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.core.Environment env, java.lang.String stackName, java.util.Map<java.lang.String, java.lang.String> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.env = env;
            this.stackName = stackName;
            this.tags = tags;
        }

        @Override
        public software.amazon.awscdk.core.Environment getEnv() {
            return this.env;
        }

        @Override
        public java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getEnv() != null) {
                obj.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getStackName() != null) {
                obj.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackProps.Jsii$Proxy that = (StackProps.Jsii$Proxy) o;

            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.env != null ? this.env.hashCode() : 0;
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

    }
}
