package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.2 (build dfe9aaf)", date = "2019-08-29T13:33:54.234Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Arn")
public class Arn extends software.amazon.jsii.JsiiObject {

    protected Arn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Arn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates an ARN from components.
     * 
     * If `partition`, `region` or `account` are not specified, the stack's
     * partition, region and account will be used.
     * 
     * If any component is the empty string, an empty string will be inserted
     * into the generated ARN at the location that component corresponds to.
     * 
     * The ARN will be formatted as follows:
     * 
     *    arn:{partition}:{service}:{region}:{account}:{resource}{sep}{resource-name}
     * 
     * The required ARN pieces that are omitted will be taken from the stack that
     * the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
     * can be 'undefined'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.String format(final software.amazon.awscdk.core.ArnComponents components, final software.amazon.awscdk.core.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "format", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(components, "components is required"), java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse.
     * @param sepIfToken The separator used to separate resource from resourceName.
     * @param hasName Whether there is a name component in the ARN at all.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.ArnComponents parse(final java.lang.String arn, final java.lang.String sepIfToken, final java.lang.Boolean hasName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse.
     * @param sepIfToken The separator used to separate resource from resourceName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.ArnComponents parse(final java.lang.String arn, final java.lang.String sepIfToken) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.ArnComponents parse(final java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }
}
