package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:16:43.954Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOutputProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The value of the property returned by the aws cloudformation describe-stacks command. The value of an output can include literals, parameter references, pseudo-parameters, a mapping value, or intrinsic functions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getValue();

    /**
     * A condition to associate with this output value.
     * 
     * If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     * 
     * Default: - No condition is associated with the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnCondition getCondition();

    /**
     * A String type that describes the output value. The description can be a maximum of 4 K in length.
     * 
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * The name used to export the value of this output across stacks.
     * 
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     * 
     * Default: - the output is not exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getExportName();

    /**
     * @return a {@link Builder} of {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String value;
        private software.amazon.awscdk.core.CfnCondition condition;
        private java.lang.String description;
        private java.lang.String exportName;

        /**
         * Sets the value of Value
         * @param value The value of the property returned by the aws cloudformation describe-stacks command. The value of an output can include literals, parameter references, pseudo-parameters, a mapping value, or intrinsic functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of Condition
         * @param condition A condition to associate with this output value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.core.CfnCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description A String type that describes the output value. The description can be a maximum of 4 K in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of ExportName
         * @param exportName The name used to export the value of this output across stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportName(java.lang.String exportName) {
            this.exportName = exportName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnOutputProps build() {
            return new Jsii$Proxy(value, condition, description, exportName);
        }

    }

    /**
     * An implementation for {@link CfnOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOutputProps {
        private final java.lang.String value;
        private final software.amazon.awscdk.core.CfnCondition condition;
        private final java.lang.String description;
        private final java.lang.String exportName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.value = this.jsiiGet("value", java.lang.String.class);
            this.condition = this.jsiiGet("condition", software.amazon.awscdk.core.CfnCondition.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.exportName = this.jsiiGet("exportName", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String value, software.amazon.awscdk.core.CfnCondition condition, java.lang.String description, java.lang.String exportName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.value = java.util.Objects.requireNonNull(value, "value is required");
            this.condition = condition;
            this.description = description;
            this.exportName = exportName;
        }

        @Override
        public java.lang.String getValue() {
            return this.value;
        }

        @Override
        public software.amazon.awscdk.core.CfnCondition getCondition() {
            return this.condition;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getExportName() {
            return this.exportName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("value", om.valueToTree(this.getValue()));
            if (this.getCondition() != null) {
                obj.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExportName() != null) {
                obj.set("exportName", om.valueToTree(this.getExportName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOutputProps.Jsii$Proxy that = (CfnOutputProps.Jsii$Proxy) o;

            if (!value.equals(that.value)) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.exportName != null ? this.exportName.equals(that.exportName) : that.exportName == null;
        }

        @Override
        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exportName != null ? this.exportName.hashCode() : 0);
            return result;
        }

    }
}
